/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;

public class SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(SecureTestUtil.class);
    private static final int WAIT_TIME = 10000;

    public static void enableSecurity(Configuration conf) throws IOException {
        conf.set("hadoop.security.authorization", "false");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName() + "," + SecureBulkLoadEndpoint.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", AccessController.class.getName());
        String currentUser = User.getCurrent().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("admin,");
        sb.append(currentUser);
        for (int i = 0; i < 5; ++i) {
            sb.append(',');
            sb.append(currentUser);
            sb.append(".hfs.");
            sb.append(i);
        }
        conf.set("hbase.superuser", sb.toString());
        conf.setInt("hfile.format.version", 3);
    }

    public static void verifyConfiguration(Configuration conf) {
        if (!(conf.get("hbase.coprocessor.master.classes").contains(AccessController.class.getName()) && conf.get("hbase.coprocessor.region.classes").contains(AccessController.class.getName()) && conf.get("hbase.coprocessor.regionserver.classes").contains(AccessController.class.getName()))) {
            throw new RuntimeException("AccessController is missing from a system coprocessor list");
        }
        if (conf.getInt("hfile.format.version", 2) < 3) {
            throw new RuntimeException("Post 0.96 security features require HFile version >= 3");
        }
    }

    public static void checkTablePerms(Configuration conf, byte[] table, byte[] family, byte[] column, Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new TablePermission(TableName.valueOf((byte[])table), family, column, new Permission.Action[]{actions[i]});
        }
        SecureTestUtil.checkTablePerms(conf, table, perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkTablePerms(Configuration conf, byte[] table, Permission ... perms) throws IOException {
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission p : perms) {
            request.addPermission(ProtobufUtil.toPermission((Permission)p));
        }
        HTable acl = new HTable(conf, table);
        try {
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)acl.coprocessorService(new byte[0]));
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException((ServiceException)se);
            }
        }
        finally {
            acl.close();
        }
    }

    public static void verifyAllowed(User user, AccessTestAction ... actions) throws Exception {
        for (AccessTestAction action : actions) {
            try {
                List results;
                Object obj = user.runAs((PrivilegedExceptionAction)action);
                if (obj == null || !(obj instanceof List) || (results = (List)obj) == null || !results.isEmpty()) continue;
                Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
            }
            catch (AccessDeniedException ade) {
                Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
            }
        }
    }

    public static void verifyAllowed(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyAllowed(user, action);
        }
    }

    public static void verifyAllowed(User user, AccessTestAction action, int count) throws Exception {
        try {
            Object obj = user.runAs((PrivilegedExceptionAction)action);
            if (obj != null && obj instanceof List) {
                List results = (List)obj;
                if (results != null && results.isEmpty()) {
                    Assert.fail((String)("Empty non null results from action for user '" + user.getShortName() + "'"));
                }
                Assert.assertEquals((long)count, (long)results.size());
            }
        }
        catch (AccessDeniedException ade) {
            Assert.fail((String)("Expected action to pass for user '" + user.getShortName() + "' but was denied"));
        }
    }

    public static void verifyDeniedWithException(User user, AccessTestAction ... actions) throws Exception {
        SecureTestUtil.verifyDenied(user, true, actions);
    }

    public static void verifyDeniedWithException(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyDenied(user, true, action);
        }
    }

    public static void verifyDenied(User user, AccessTestAction ... actions) throws Exception {
        SecureTestUtil.verifyDenied(user, false, actions);
    }

    public static void verifyDenied(User user, boolean requireException, AccessTestAction ... actions) throws Exception {
        for (AccessTestAction action : actions) {
            try {
                List results;
                Object obj = user.runAs((PrivilegedExceptionAction)action);
                if (requireException) {
                    Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
                }
                if (obj == null || !(obj instanceof List) || (results = (List)obj) == null || results.isEmpty()) continue;
                Assert.fail((String)("Unexpected results for user '" + user.getShortName() + "'"));
            }
            catch (IOException e) {
                boolean isAccessDeniedException = false;
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    for (Throwable ex : ((RetriesExhaustedWithDetailsException)e).getCauses()) {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    }
                } else {
                    Throwable ex = e;
                    do {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    } while ((ex = ex.getCause()) != null);
                }
                if (isAccessDeniedException) continue;
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
            catch (UndeclaredThrowableException ute) {
                ServiceException se;
                Throwable ex = ute.getUndeclaredThrowable();
                if (ex instanceof PrivilegedActionException) {
                    ex = ((PrivilegedActionException)ex).getException();
                }
                if (ex instanceof ServiceException && (se = (ServiceException)ex).getCause() != null && se.getCause() instanceof AccessDeniedException) {
                    return;
                }
                Assert.fail((String)("Expected exception was not thrown for user '" + user.getShortName() + "'"));
            }
        }
    }

    public static void verifyDenied(AccessTestAction action, User ... users) throws Exception {
        for (User user : users) {
            SecureTestUtil.verifyDenied(user, action);
        }
    }

    private static List<AccessController> getAccessControllers(MiniHBaseCluster cluster) {
        ArrayList result = Lists.newArrayList();
        for (JVMClusterUtil.RegionServerThread t : cluster.getLiveRegionServerThreads()) {
            for (HRegion region : t.getRegionServer().getOnlineRegionsLocalContext()) {
                Coprocessor cp = region.getCoprocessorHost().findCoprocessor(AccessController.class.getName());
                if (cp == null) continue;
                result.add((AccessController)cp);
            }
        }
        return result;
    }

    private static Map<AccessController, Long> getAuthManagerMTimes(MiniHBaseCluster cluster) {
        HashMap result = Maps.newHashMap();
        for (AccessController ac : SecureTestUtil.getAccessControllers(cluster)) {
            result.put(ac, ac.getAuthManager().getMTime());
        }
        return result;
    }

    private static void updateACLs(final HBaseTestingUtility util, Callable c) throws Exception {
        final Map<AccessController, Long> oldMTimes = SecureTestUtil.getAuthManagerMTimes(util.getHBaseCluster());
        c.call();
        util.waitFor(10000L, 100L, new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                Map mtimes = SecureTestUtil.getAuthManagerMTimes(util.getHBaseCluster());
                for (Map.Entry e : mtimes.entrySet()) {
                    if (!oldMTimes.containsKey(e.getKey())) {
                        LOG.error((Object)("Snapshot of AccessController state does not include instance on region " + ((AccessController)e.getKey()).getRegion().getRegionNameAsString()));
                        return false;
                    }
                    long old = (Long)oldMTimes.get(e.getKey());
                    long now = (Long)e.getValue();
                    if (now > old) continue;
                    LOG.info((Object)("AccessController on region " + ((AccessController)e.getKey()).getRegion().getRegionNameAsString() + " has not updated: mtime=" + now));
                    return false;
                }
                return true;
            }
        });
    }

    public static void grantGlobal(final HBaseTestingUtility util, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HTable acl = new HTable(util.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user, (Permission.Action[])actions);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        });
    }

    public static void revokeGlobal(final HBaseTestingUtility util, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HTable acl = new HTable(util.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user, (Permission.Action[])actions);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        });
    }

    public static void grantOnNamespace(final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HTable acl = new HTable(util.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user, (String)namespace, (Permission.Action[])actions);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        });
    }

    public static void grantOnNamespaceUsingAccessControlClient(HBaseTestingUtility util, final Configuration conf, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Configuration)conf, (String)namespace, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespaceUsingAccessControlClient(HBaseTestingUtility util, final Configuration conf, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke((Configuration)conf, (String)namespace, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeFromNamespace(final HBaseTestingUtility util, final String user, final String namespace, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HTable acl = new HTable(util.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user, (String)namespace, (Permission.Action[])actions);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        });
    }

    public static void grantOnTable(final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HTable acl = new HTable(util.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user, (TableName)table, (byte[])family, (byte[])qualifier, (Permission.Action[])actions);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        });
    }

    public static void grantOnTableUsingAccessControlClient(HBaseTestingUtility util, final Configuration conf, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Configuration)conf, (TableName)table, (String)user, (byte[])family, (byte[])qualifier, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void grantGlobalUsingAccessControlClient(HBaseTestingUtility util, final Configuration conf, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.grant((Configuration)conf, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeFromTable(final HBaseTestingUtility util, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                HTable acl = new HTable(util.getConfiguration(), AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user, (TableName)table, (byte[])family, (byte[])qualifier, (Permission.Action[])actions);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        });
    }

    public static void revokeFromTableUsingAccessControlClient(HBaseTestingUtility util, final Configuration conf, final String user, final TableName table, final byte[] family, final byte[] qualifier, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke((Configuration)conf, (TableName)table, (String)user, (byte[])family, (byte[])qualifier, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    public static void revokeGlobalUsingAccessControlClient(HBaseTestingUtility util, final Configuration conf, final String user, final Permission.Action ... actions) throws Exception {
        SecureTestUtil.updateACLs(util, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AccessControlClient.revoke((Configuration)conf, (String)user, (Permission.Action[])actions);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return null;
            }
        });
    }

    static interface AccessTestAction
    extends PrivilegedExceptionAction<Object> {
    }
}

