/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHMasterRPCException {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRPCException() throws Exception {
        block10: {
            HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
            TEST_UTIL.startMiniZKCluster();
            Configuration conf = TEST_UTIL.getConfiguration();
            conf.set("hbase.master.port", "0");
            HMaster hm = new HMaster(conf);
            ServerName sm = hm.getServerName();
            RpcClient rpcClient = new RpcClient(conf, "default-cluster");
            for (int i = 0; i < 20; ++i) {
                try {
                    BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(sm, User.getCurrent(), 0);
                    MasterProtos.MasterService.BlockingInterface stub = MasterProtos.MasterService.newBlockingStub((BlockingRpcChannel)channel);
                    stub.isMasterRunning(null, MasterProtos.IsMasterRunningRequest.getDefaultInstance());
                    Assert.fail();
                }
                catch (ServiceException ex) {
                    IOException ie = ProtobufUtil.getRemoteException((ServiceException)ex);
                    if (!(ie instanceof SocketTimeoutException)) {
                        if (ie.getMessage().startsWith("org.apache.hadoop.hbase.ipc.ServerNotRunningYetException: Server is not running yet")) {
                            System.out.println("Expected exception: " + ie.getMessage());
                            rpcClient.stop();
                            return;
                        }
                        throw ex;
                    }
                    System.err.println("Got SocketTimeoutException. Will retry. ");
                }
                catch (Throwable t) {
                    Assert.fail((String)("Unexpected throwable: " + t));
                }
                Thread.sleep(100L);
            }
            Assert.fail();
            break block10;
            finally {
                rpcClient.stop();
            }
        }
    }
}

