/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMultiSlaveReplication {
    private static final Log LOG = LogFactory.getLog(TestReplicationBase.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static Configuration conf3;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static HBaseTestingUtility utility3;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 100;
    private static final byte[] tableName;
    private static final byte[] famName;
    private static final byte[] row;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] noRepfamName;
    private static HTableDescriptor table;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setBoolean("hbase.replication", true);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        new ZooKeeperWatcher(conf1, "cluster1", null, true);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf3 = new Configuration(conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf2, "cluster3", null, true);
        utility3 = new HBaseTestingUtility(conf3);
        utility3.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf3, "cluster3", null, true);
        table = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        table.addFamily(fam);
    }

    @Test(timeout=300000L)
    public void testMultiSlaveReplication() throws Exception {
        LOG.info((Object)"testCyclicReplication");
        MiniHBaseCluster master = utility1.startMiniCluster();
        utility2.startMiniCluster();
        utility3.startMiniCluster();
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        new HBaseAdmin(conf1).createTable(table);
        new HBaseAdmin(conf2).createTable(table);
        new HBaseAdmin(conf3).createTable(table);
        HTable htable1 = new HTable(conf1, tableName);
        htable1.setWriteBufferSize(1024L);
        HTable htable2 = new HTable(conf2, tableName);
        htable2.setWriteBufferSize(1024L);
        HTable htable3 = new HTable(conf3, tableName);
        htable3.setWriteBufferSize(1024L);
        admin1.addPeer("1", utility2.getClusterKey());
        this.putAndWait(row, famName, htable1, htable2);
        this.deleteAndWait(row, htable1, htable2);
        this.checkRow(row, 0, htable3);
        this.putAndWait(row2, famName, htable1, htable2);
        new HBaseAdmin(conf1).rollHLogWriter(master.getRegionServer(0).getServerName().toString());
        this.putAndWait(row3, famName, htable1, htable2);
        admin1.addPeer("2", utility3.getClusterKey());
        this.putAndWait(row1, famName, htable1, htable2, htable3);
        this.deleteAndWait(row1, htable1, htable2, htable3);
        this.checkRow(row2, 0, htable3);
        this.checkRow(row3, 1, htable3);
        Put p = new Put(row);
        p.add(famName, row, row);
        htable1.put(p);
        new HBaseAdmin(conf1).rollHLogWriter(master.getRegionServer(0).getServerName().toString());
        this.deleteAndWait(row2, htable1, htable2, htable3);
        this.checkRow(row, 1, htable2);
        this.checkWithWait(row, 1, htable3);
        this.deleteAndWait(row, htable1, htable2, htable3);
        this.deleteAndWait(row3, htable1, htable2, htable3);
        utility3.shutdownMiniCluster();
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    private void checkWithWait(byte[] row, int count, HTable table) throws Exception {
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time while getting the row.");
            }
            boolean rowReplicated = false;
            Result res = table.get(get);
            if (res.size() >= 1) {
                LOG.info((Object)"Row is replicated");
                rowReplicated = true;
                Assert.assertEquals((long)count, (long)res.size());
                break;
            }
            if (rowReplicated) break;
            Thread.sleep(500L);
        }
    }

    private void checkRow(byte[] row, int count, HTable ... tables) throws IOException {
        Get get = new Get(row);
        for (HTable table : tables) {
            Result res = table.get(get);
            Assert.assertEquals((long)count, (long)res.size());
        }
    }

    private void deleteAndWait(byte[] row, HTable source, HTable ... targets) throws Exception {
        Delete del = new Delete(row);
        source.delete(del);
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            boolean removedFromAll = true;
            for (HTable target : targets) {
                Result res = target.get(get);
                if (res.size() < 1) continue;
                LOG.info((Object)"Row not deleted");
                removedFromAll = false;
                break;
            }
            if (removedFromAll) break;
            Thread.sleep(500L);
        }
    }

    private void putAndWait(byte[] row, byte[] fam, HTable source, HTable ... targets) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, row);
        source.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            boolean replicatedToAll = true;
            for (HTable target : targets) {
                Result res = target.get(get);
                if (res.size() == 0) {
                    LOG.info((Object)"Row not available");
                    replicatedToAll = false;
                    break;
                }
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
            }
            if (replicatedToAll) break;
            Thread.sleep(500L);
        }
    }

    static {
        tableName = Bytes.toBytes((String)"test");
        famName = Bytes.toBytes((String)"f");
        row = Bytes.toBytes((String)"row");
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        row3 = Bytes.toBytes((String)"row3");
        noRepfamName = Bytes.toBytes((String)"norep");
    }
}

