/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterFileSystem {
    private static final Log LOG = LogFactory.getLog(TestMasterFileSystem.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFsUriSetProperly() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        Path masterRoot = FSUtils.getRootDir((Configuration)fs.conf);
        Path rootDir = FSUtils.getRootDir((Configuration)fs.getFileSystem().getConf());
        LOG.debug((Object)("from fs uri:" + FileSystem.getDefaultUri((Configuration)fs.getFileSystem().getConf())));
        LOG.debug((Object)("from configuration uri:" + FileSystem.getDefaultUri((Configuration)fs.conf)));
        Assert.assertEquals((Object)masterRoot, (Object)rootDir);
    }

    @Test
    public void testRemoveStaleRecoveringRegionsDuringMasterInitialization() throws Exception {
        if (!UTIL.getConfiguration().getBoolean("hbase.master.distributed.log.replay", false)) {
            return;
        }
        LOG.info((Object)"Starting testRemoveStaleRecoveringRegionsDuringMasterInitialization");
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        String failedRegion = "failedRegoin1";
        String staleRegion = "staleRegion";
        ServerName inRecoveryServerName = ServerName.valueOf((String)"mgr,1,1");
        ServerName previouselyFaildServerName = ServerName.valueOf((String)"previous,1,1");
        String walPath = "/hbase/data/.logs/" + inRecoveryServerName.getServerName() + "-splitting/test";
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(UTIL);
        zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZooKeeperWatcher)zkw, (String)walPath), new SplitLogTask.Owned(inRecoveryServerName, fs.getLogRecoveryMode()).toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String staleRegionPath = ZKUtil.joinZNode((String)zkw.recoveringRegionsZNode, (String)staleRegion);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)staleRegionPath);
        String inRecoveringRegionPath = ZKUtil.joinZNode((String)zkw.recoveringRegionsZNode, (String)failedRegion);
        inRecoveringRegionPath = ZKUtil.joinZNode((String)inRecoveringRegionPath, (String)inRecoveryServerName.getServerName());
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)inRecoveringRegionPath);
        HashSet<ServerName> servers = new HashSet<ServerName>();
        servers.add(previouselyFaildServerName);
        fs.removeStaleRecoveringRegionsFromZK(servers);
        Assert.assertFalse((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)staleRegionPath) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)inRecoveringRegionPath) != -1 ? 1 : 0) != 0);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)zkw, (String)zkw.recoveringRegionsZNode);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)zkw, (String)zkw.splitLogZNode);
        zkw.close();
    }
}

