/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterCoprocessorExceptionWithAbort {
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static byte[] TEST_TABLE = Bytes.toBytes((String)"observed_table");
    private static byte[] TEST_FAMILY = Bytes.toBytes((String)"fam1");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", BuggyMasterObserver.class.getName());
        conf.setBoolean("hbase.coprocessor.abortonerror", true);
        conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 2);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=30000L)
    public void testExceptionFromCoprocessorWhenCreatingTable() throws IOException {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        MasterCoprocessorHost host = master.getCoprocessorHost();
        BuggyMasterObserver cp = (BuggyMasterObserver)host.findCoprocessor(BuggyMasterObserver.class.getName());
        Assert.assertFalse((String)"No table created yet", (boolean)cp.wasCreateTableCalled());
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(UTIL.getConfiguration(), "unittest", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException("Fatal ZK error: " + why, e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        MasterTracker masterTracker = new MasterTracker(zkw, "/hbase/master", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException("Fatal ZK master tracker error, why=", e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        masterTracker.start();
        zkw.registerListener((ZooKeeperListener)masterTracker);
        Assert.assertTrue((boolean)master.getLoadedCoprocessors().contains(BuggyMasterObserver.class.getName()));
        CreateTableThread createTableThread = new CreateTableThread(UTIL);
        createTableThread.start();
        for (int i = 0; i < 30 && !masterTracker.masterZKNodeWasDeleted; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)"InterruptedException while waiting for master zk node to be deleted.");
            }
        }
        Assert.assertTrue((String)"Master aborted on coprocessor exception, as expected.", (boolean)masterTracker.masterZKNodeWasDeleted);
        createTableThread.interrupt();
        try {
            createTableThread.join(1000L);
        }
        catch (InterruptedException e) {
            Assert.assertTrue((String)"Ignoring InterruptedException while waiting for  createTableThread.join().", (boolean)true);
        }
    }

    public static class BuggyMasterObserver
    extends BaseMasterObserver {
        private boolean preCreateTableCalled;
        private boolean postCreateTableCalled;
        private boolean startCalled;
        private boolean postStartMasterCalled;

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> env, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            Integer i;
            Integer n = i = null;
            Integer n2 = i = Integer.valueOf(i + 1);
            i = n;
        }

        public boolean wasCreateTableCalled() {
            return this.preCreateTableCalled && this.postCreateTableCalled;
        }

        public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            this.postStartMasterCalled = true;
        }

        public boolean wasStartMasterCalled() {
            return this.postStartMasterCalled;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            this.startCalled = true;
        }

        public boolean wasStarted() {
            return this.startCalled;
        }
    }

    public static class CreateTableThread
    extends Thread {
        HBaseTestingUtility UTIL;

        public CreateTableThread(HBaseTestingUtility UTIL) {
            this.UTIL = UTIL;
        }

        @Override
        public void run() {
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TEST_TABLE));
            htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
            try {
                HBaseAdmin admin = this.UTIL.getHBaseAdmin();
                admin.createTable(htd);
                Assert.fail((String)"BuggyMasterObserver failed to throw an exception.");
            }
            catch (IOException e) {
                Assert.assertEquals((String)"HBaseAdmin threw an interrupted IOException as expected.", (Object)e.getClass().getName(), (Object)"java.io.InterruptedIOException");
            }
        }
    }

    public static class MasterTracker
    extends ZooKeeperNodeTracker {
        public boolean masterZKNodeWasDeleted = false;

        public MasterTracker(ZooKeeperWatcher zkw, String masterNode, Abortable abortable) {
            super(zkw, masterNode, abortable);
        }

        public synchronized void nodeDeleted(String path) {
            if (path.equals("/hbase/master")) {
                this.masterZKNodeWasDeleted = true;
            }
        }
    }
}

