/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannerWithBulkload {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    private static void createTable(HBaseAdmin admin, String tableName) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        admin.createTable(desc);
    }

    @Test
    public void testBulkLoad() throws Exception {
        String tableName = "testBulkLoad";
        long l = System.currentTimeMillis();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        TestScannerWithBulkload.createTable(admin, tableName);
        Scan scan = this.createScan();
        HTable table = this.init(admin, l, scan, tableName);
        Path hfilePath = this.writeToHFile(l, "/temp/testBulkLoad/", "/temp/testBulkLoad/col/file", false);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(conf);
        bulkload.doBulkLoad(hfilePath, table);
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        result = this.scanAfterBulkLoad(scanner, result, "version2");
        Put put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version3")));
        table.put(put0);
        table.flushCommits();
        admin.flush(tableName);
        scanner = table.getScanner(scan);
        result = scanner.next();
        while (result != null) {
            List kvs = result.getColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
            for (KeyValue _kv : kvs) {
                if (!Bytes.toString((byte[])_kv.getRow()).equals("row1")) continue;
                System.out.println(Bytes.toString((byte[])_kv.getRow()));
                System.out.println(Bytes.toString((byte[])_kv.getQualifier()));
                System.out.println(Bytes.toString((byte[])_kv.getValue()));
                Assert.assertEquals((String)"version3", (String)Bytes.toString((byte[])_kv.getValue()));
            }
            result = scanner.next();
        }
        scanner.close();
        table.close();
    }

    private Result scanAfterBulkLoad(ResultScanner scanner, Result result, String expctedVal) throws IOException {
        while (result != null) {
            List kvs = result.getColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
            for (KeyValue _kv : kvs) {
                if (!Bytes.toString((byte[])_kv.getRow()).equals("row1")) continue;
                System.out.println(Bytes.toString((byte[])_kv.getRow()));
                System.out.println(Bytes.toString((byte[])_kv.getQualifier()));
                System.out.println(Bytes.toString((byte[])_kv.getValue()));
                Assert.assertEquals((String)expctedVal, (String)Bytes.toString((byte[])_kv.getValue()));
            }
            result = scanner.next();
        }
        return result;
    }

    private Path writeToHFile(long l, String hFilePath, String pathStr, boolean nativeHFile) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path hfilePath = new Path(hFilePath);
        fs.mkdirs(hfilePath);
        Path path = new Path(pathStr);
        HFile.WriterFactory wf = HFile.getWriterFactoryNoCache((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertNotNull((Object)wf);
        HFileContext context = new HFileContext();
        HFile.Writer writer = wf.withPath(fs, path).withFileContext(context).create();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version2"));
        if (nativeHFile) {
            kv.setMvccVersion(9999999L);
        }
        writer.append(kv);
        if (nativeHFile) {
            writer.appendFileInfo(StoreFile.MAX_SEQ_ID_KEY, Bytes.toBytes((long)new Long(9999999L)));
        } else {
            writer.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
        }
        writer.close();
        return hfilePath;
    }

    private HTable init(HBaseAdmin admin, long l, Scan scan, String tableName) throws Exception {
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Put put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version0")));
        table.put(put0);
        table.flushCommits();
        admin.flush(tableName);
        Put put1 = new Put(Bytes.toBytes((String)"row2"));
        put1.add((Cell)new KeyValue(Bytes.toBytes((String)"row2"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version0")));
        table.put(put1);
        table.flushCommits();
        admin.flush(tableName);
        admin.close();
        put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version1")));
        table.put(put0);
        table.flushCommits();
        admin.flush(tableName);
        admin.compact(tableName);
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        List kvs = result.getColumn(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
        Assert.assertEquals((int)1, (int)kvs.size());
        Assert.assertEquals((String)"version1", (String)Bytes.toString((byte[])((KeyValue)kvs.get(0)).getValue()));
        scanner.close();
        return table;
    }

    @Test
    public void testBulkLoadWithParallelScan() throws Exception {
        String tableName = "testBulkLoadWithParallelScan";
        final long l = System.currentTimeMillis();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        TestScannerWithBulkload.createTable(admin, tableName);
        Scan scan = this.createScan();
        final HTable table = this.init(admin, l, scan, tableName);
        final Path hfilePath = this.writeToHFile(l, "/temp/testBulkLoadWithParallelScan/", "/temp/testBulkLoadWithParallelScan/col/file", false);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        final LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(conf);
        ResultScanner scanner = table.getScanner(scan);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    Put put1 = new Put(Bytes.toBytes((String)"row5"));
                    put1.add((Cell)new KeyValue(Bytes.toBytes((String)"row5"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version0")));
                    table.put(put1);
                    table.flushCommits();
                    bulkload.doBulkLoad(hfilePath, table);
                    latch.countDown();
                }
                catch (TableNotFoundException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        latch.await();
        Result result = scanner.next();
        this.scanAfterBulkLoad(scanner, result, "version2");
        scanner.close();
        table.close();
    }

    @Test
    public void testBulkLoadNativeHFile() throws Exception {
        String tableName = "testBulkLoadNativeHFile";
        long l = System.currentTimeMillis();
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        TestScannerWithBulkload.createTable(admin, tableName);
        Scan scan = this.createScan();
        HTable table = this.init(admin, l, scan, tableName);
        Path hfilePath = this.writeToHFile(l, "/temp/testBulkLoadNativeHFile/", "/temp/testBulkLoadNativeHFile/col/file", true);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(conf);
        bulkload.doBulkLoad(hfilePath, table);
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        result = this.scanAfterBulkLoad(scanner, result, "version2");
        scanner.close();
        table.close();
    }

    private Scan createScan() {
        Scan scan = new Scan();
        scan.setMaxVersions(3);
        return scan;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

