/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableSplit {
    @Test
    public void testHashCode() {
        TableSplit split1 = new TableSplit(TableName.valueOf((String)"table"), "row-start".getBytes(), "row-end".getBytes(), "location");
        TableSplit split2 = new TableSplit(TableName.valueOf((String)"table"), "row-start".getBytes(), "row-end".getBytes(), "location");
        Assert.assertEquals((Object)split1, (Object)split2);
        Assert.assertTrue((split1.hashCode() == split2.hashCode() ? 1 : 0) != 0);
        HashSet<TableSplit> set = new HashSet<TableSplit>(2);
        set.add(split1);
        set.add(split2);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode_length() {
        TableSplit split1 = new TableSplit(TableName.valueOf((String)"table"), "row-start".getBytes(), "row-end".getBytes(), "location", 1984L);
        TableSplit split2 = new TableSplit(TableName.valueOf((String)"table"), "row-start".getBytes(), "row-end".getBytes(), "location", 1982L);
        Assert.assertEquals((Object)split1, (Object)split2);
        Assert.assertTrue((split1.hashCode() == split2.hashCode() ? 1 : 0) != 0);
        HashSet<TableSplit> set = new HashSet<TableSplit>(2);
        set.add(split1);
        set.add(split2);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testLengthIsSerialized() throws Exception {
        TableSplit split1 = new TableSplit(TableName.valueOf((String)"table"), "row-start".getBytes(), "row-end".getBytes(), "location", 666L);
        TableSplit deserialized = new TableSplit(TableName.valueOf((String)"table"), "row-start2".getBytes(), "row-end2".getBytes(), "location1");
        ReflectionUtils.copy((Configuration)new Configuration(), (Object)split1, (Object)deserialized);
        Assert.assertEquals((long)666L, (long)deserialized.getLength());
    }

    @Test
    public void testToString() {
        TableSplit split = new TableSplit(TableName.valueOf((String)"table"), "row-start".getBytes(), "row-end".getBytes(), "location");
        String str = "HBase table split(table name: table, scan: , start row: row-start, end row: row-end, region location: location)";
        Assert.assertEquals((Object)str, (Object)split.toString());
        split = new TableSplit((TableName)null, null, null, null);
        str = "HBase table split(table name: null, scan: , start row: null, end row: null, region location: null)";
        Assert.assertEquals((Object)str, (Object)split.toString());
    }
}

