/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HRegionPartitioner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHRegionPartitioner {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testHRegionPartitioner() throws Exception {
        byte[][] families = new byte[][]{Bytes.toBytes((String)"familyA"), Bytes.toBytes((String)"familyB")};
        UTIL.createTable(Bytes.toBytes((String)"out_table"), (byte[][])families, 1, Bytes.toBytes((String)"aa"), Bytes.toBytes((String)"cc"), 3);
        HRegionPartitioner partitioner = new HRegionPartitioner();
        Configuration configuration = UTIL.getConfiguration();
        configuration.set("hbase.mapred.outputtable", "out_table");
        partitioner.setConf(configuration);
        ImmutableBytesWritable writable = new ImmutableBytesWritable(Bytes.toBytes((String)"bb"));
        Assert.assertEquals((long)1L, (long)partitioner.getPartition(writable, (Object)10L, 3));
        Assert.assertEquals((long)0L, (long)partitioner.getPartition(writable, (Object)10L, 1));
    }
}

