/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFileLink {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHDFSLinkReadDuringRename() throws Exception {
        HBaseTestingUtility testUtil = new HBaseTestingUtility();
        Configuration conf = testUtil.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.client.read.prefetch.size", 0x200000);
        testUtil.startMiniDFSCluster(1);
        MiniDFSCluster cluster = testUtil.getDFSCluster();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertEquals((Object)"hdfs", (Object)fs.getUri().getScheme());
        try {
            this.testLinkReadDuringRename((FileSystem)fs, testUtil.getDefaultRootDirPath());
        }
        finally {
            testUtil.shutdownMiniCluster();
        }
    }

    @Test
    public void testLocalLinkReadDuringRename() throws IOException {
        HBaseTestingUtility testUtil = new HBaseTestingUtility();
        FileSystem fs = testUtil.getTestFileSystem();
        Assert.assertEquals((Object)"file", (Object)fs.getUri().getScheme());
        this.testLinkReadDuringRename(fs, testUtil.getDataTestDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLinkReadDuringRename(FileSystem fs, Path rootDir) throws IOException {
        Path originalPath = new Path(rootDir, "test.file");
        Path archivedPath = new Path(rootDir, "archived.file");
        this.writeSomeData(fs, originalPath, 0x10000000L, (byte)2);
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(originalPath);
        files.add(archivedPath);
        FileLink link = new FileLink(files);
        FSDataInputStream in = link.open(fs);
        try {
            byte[] data = new byte[8192];
            long size = 0L;
            int n = in.read(data);
            TestFileLink.dataVerify(data, n, (byte)2);
            size += (long)n;
            if (FSUtils.WINDOWS) {
                in.close();
            }
            Assert.assertFalse((boolean)fs.exists(archivedPath));
            fs.rename(originalPath, archivedPath);
            Assert.assertFalse((boolean)fs.exists(originalPath));
            Assert.assertTrue((boolean)fs.exists(archivedPath));
            if (FSUtils.WINDOWS) {
                in = link.open(fs);
                in.read(data);
            }
            while ((n = in.read(data)) > 0) {
                TestFileLink.dataVerify(data, n, (byte)2);
                size += (long)n;
            }
            Assert.assertEquals((long)0x10000000L, (long)size);
        }
        finally {
            in.close();
            if (fs.exists(originalPath)) {
                fs.delete(originalPath);
            }
            if (fs.exists(archivedPath)) {
                fs.delete(archivedPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHDFSLinkReadDuringDelete() throws Exception {
        HBaseTestingUtility testUtil = new HBaseTestingUtility();
        Configuration conf = testUtil.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.client.read.prefetch.size", 0x200000);
        testUtil.startMiniDFSCluster(1);
        MiniDFSCluster cluster = testUtil.getDFSCluster();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertEquals((Object)"hdfs", (Object)fs.getUri().getScheme());
        try {
            ArrayList<Path> files = new ArrayList<Path>();
            for (int i = 0; i < 3; ++i) {
                Path path = new Path(String.format("test-data-%d", i));
                this.writeSomeData((FileSystem)fs, path, 0x100000L, (byte)i);
                files.add(path);
            }
            FileLink link = new FileLink(files);
            FSDataInputStream in = link.open((FileSystem)fs);
            try {
                byte[] data = new byte[8192];
                int n = in.read(data);
                TestFileLink.dataVerify(data, n, (byte)0);
                fs.delete((Path)files.get(0));
                TestFileLink.skipBuffer(in, (byte)0);
                n = in.read(data);
                TestFileLink.dataVerify(data, n, (byte)1);
                fs.delete((Path)files.get(1));
                TestFileLink.skipBuffer(in, (byte)1);
                n = in.read(data);
                TestFileLink.dataVerify(data, n, (byte)2);
                fs.delete((Path)files.get(2));
                TestFileLink.skipBuffer(in, (byte)2);
                try {
                    n = in.read(data);
                    assert (n <= 0);
                }
                catch (FileNotFoundException e) {
                    Assert.assertTrue((boolean)true);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            testUtil.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSomeData(FileSystem fs, Path path, long size, byte v) throws IOException {
        byte[] data = new byte[4096];
        for (int i = 0; i < data.length; ++i) {
            data[i] = v;
        }
        FSDataOutputStream stream = fs.create(path);
        try {
            for (long written = 0L; written < size; written += (long)data.length) {
                stream.write(data, 0, data.length);
            }
        }
        finally {
            stream.close();
        }
    }

    private static void dataVerify(byte[] data, int n, byte v) {
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((long)v, (long)data[i]);
        }
    }

    private static void skipBuffer(FSDataInputStream in, byte v) throws IOException {
        byte[] data = new byte[8192];
        try {
            int n;
            while ((n = in.read(data)) == data.length) {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == v) continue;
                    throw new Exception("File changed");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

