// Autogenerated Jamon implementation
// /root/builds/opensource/ecosystem/dl/hbase/buildNode/10.10.1.252/maprVersion/4.0.1-mapr/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
// 26, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 9
import org.apache.hadoop.hbase.util.Bytes;
// 28, 9
import org.apache.hadoop.hbase.HRegionInfo;
// 29, 9
import org.apache.hadoop.hbase.regionserver.HRegion;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 9
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 33, 9
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 34, 9
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 35, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<HRegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 37, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 37, 60
      jamonWriter.write("\n\n    ");
      // 39, 5
      
        Collections.sort(onlineRegions);
    
      // 43, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_coprocessorStats\" data-toggle=\"tab\">Coprocessor Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 54, 17
      {
        // 54, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 54, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 57, 17
      {
        // 57, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 57, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 60, 17
      {
        // 60, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 60, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 63, 17
      {
        // 63, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 63, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 66, 17
      {
        // 66, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 66, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_coprocessorStats\">\n                ");
      // 69, 17
      {
        // 69, 17
        __jamon_innerUnit__coprocessorStats(jamonWriter, onlineRegions);
      }
      // 69, 71
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or 'catalog' tables in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If region has both an empty start and an empty end key, its the only region in the table.  See\n    <a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 84, 1
    else
    {
      // 84, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 86, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 109, 1
  private void __jamon_innerUnit__requestStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 113, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
    // 120, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 120, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 123, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 126, 13
      jamonWriter.write("<td>");
      // 126, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 126, 48
      jamonWriter.write("</td>\n            ");
      // 127, 13
      if (load != null )
      {
        // 127, 33
        jamonWriter.write("\n            <td>");
        // 128, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getReadRequestsCount()), jamonWriter);
        // 128, 50
        jamonWriter.write("</td>\n            <td>");
        // 129, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getWriteRequestsCount()), jamonWriter);
        // 129, 51
        jamonWriter.write("</td>\n            ");
      }
      // 130, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 132, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 207, 1
  private void __jamon_innerUnit__memstoreStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 211, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
    // 217, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 217, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 220, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 223, 13
      jamonWriter.write("<td>");
      // 223, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 223, 48
      jamonWriter.write("</td>\n            ");
      // 224, 13
      if (load != null )
      {
        // 224, 33
        jamonWriter.write("\n            <td>");
        // 225, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getMemstoreSizeMB()), jamonWriter);
        // 225, 47
        jamonWriter.write("m</td>\n            ");
      }
      // 226, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 228, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 173, 1
  private void __jamon_innerUnit__compactStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 177, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Compaction Progress</th>\n        </tr>\n\n        ");
    // 185, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 185, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 188, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            if  (load != null && load.getTotalCompactingKVs() > 0) {
            percentDone = String.format("%.2f", 100 *
            ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
            }
        
      // 196, 13
      jamonWriter.write("<td>");
      // 196, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 196, 48
      jamonWriter.write("</td>\n            ");
      // 197, 13
      if (load != null )
      {
        // 197, 33
        jamonWriter.write("\n            <td>");
        // 198, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalCompactingKVs()), jamonWriter);
        // 198, 51
        jamonWriter.write("</td>\n            <td>");
        // 199, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getCurrentCompactedKVs()), jamonWriter);
        // 199, 52
        jamonWriter.write("</td>\n            <td>");
        // 200, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 200, 34
        jamonWriter.write("</td>\n            ");
      }
      // 201, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 203, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 88, 1
  private void __jamon_innerUnit__baseInfo(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 92, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n        </tr>\n\n        ");
    // 99, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 99, 46
      jamonWriter.write("\n        <tr>\n            <td>");
      // 101, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 101, 48
      jamonWriter.write("</td>\n            <td>");
      // 102, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
      // 102, 60
      jamonWriter.write("</td>\n            <td>");
      // 103, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
      // 103, 58
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 105, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 137, 1
  private void __jamon_innerUnit__storeStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 141, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n        </tr>\n\n        ");
    // 152, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 152, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 155, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 158, 13
      jamonWriter.write("<td>");
      // 158, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 158, 48
      jamonWriter.write("</td>\n            ");
      // 159, 13
      if (load != null )
      {
        // 159, 33
        jamonWriter.write("\n            <td>");
        // 160, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStores()), jamonWriter);
        // 160, 39
        jamonWriter.write("</td>\n            <td>");
        // 161, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefiles()), jamonWriter);
        // 161, 43
        jamonWriter.write("</td>\n            <td>");
        // 162, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStoreUncompressedSizeMB()), jamonWriter);
        // 162, 56
        jamonWriter.write("m</td>\n            <td>");
        // 163, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefileSizeMB()), jamonWriter);
        // 163, 48
        jamonWriter.write("m</td>\n            <td>");
        // 164, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticIndexSizeKB()), jamonWriter);
        // 164, 55
        jamonWriter.write("k</td>\n            <td>");
        // 165, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticBloomSizeKB()), jamonWriter);
        // 165, 55
        jamonWriter.write("k</td>\n            ");
      }
      // 166, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 168, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 232, 1
  private void __jamon_innerUnit__coprocessorStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 236, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Coprocessor</th>\n            <th>Execution Time Statistics</th>\n        </tr>\n\n        ");
    // 243, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 243, 46
      jamonWriter.write("\n        ");
      // 244, 9
          
            HRegion region = regionServer.getFromOnlineRegions(r.getEncodedName());
            MetricsRegionWrapper mWrap = region == null ? null: region.getMetrics().getRegionWrapper();
        
      // 249, 9
      if (mWrap != null )
      {
        // 249, 30
        jamonWriter.write("\n\n            ");
        // 251, 13
        for (Map.Entry<String, DescriptiveStatistics> entry: mWrap.getCoprocessorExecutionStatistics().entrySet() )
        {
          // 251, 122
          jamonWriter.write("\n            <tr>\n                ");
          // 253, 17
          
                    String coprocessorName = entry.getKey();
                    DescriptiveStatistics ds = entry.getValue();
                
          // 257, 17
          jamonWriter.write("<td>");
          // 257, 21
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
          // 257, 52
          jamonWriter.write("</td>\n                <td>");
          // 258, 21
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(coprocessorName), jamonWriter);
          // 258, 42
          jamonWriter.write("</td>\n                <td>\n                <table class=\"table-condensed\">\n                <tr>\n                    <td>Min Time </td>\n                    <td>");
          // 263, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getMin()/1000/1000)), jamonWriter);
          // 263, 77
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>Avg Time </td>\n                    <td>");
          // 267, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getMean()/1000/1000)), jamonWriter);
          // 267, 78
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>Max Time </td>\n                    <td>");
          // 271, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getMax()/1000/1000)), jamonWriter);
          // 271, 77
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>90th percentile </td>\n                    <td>");
          // 275, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getPercentile(90d)/1000/1000)), jamonWriter);
          // 275, 87
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>95th percentile </td>\n                    <td>");
          // 279, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getPercentile(95d)/1000/1000)), jamonWriter);
          // 279, 87
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>99th percentile </td>\n                    <td>");
          // 283, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getPercentile(99d)/1000/1000)), jamonWriter);
          // 283, 87
          jamonWriter.write("ms</td>\n                </tr>\n                </table>\n                </td>\n            </tr>\n            ");
        }
        // 288, 20
        jamonWriter.write("\n        ");
      }
      // 289, 15
      jamonWriter.write("\n        ");
    }
    // 290, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
}
