/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestServerNonceManager {
    @Test
    public void testNormalStartEnd() throws Exception {
        int j;
        int i;
        long[] numbers = new long[]{0L, 1L, 2L, Long.MAX_VALUE, Long.MIN_VALUE};
        ServerNonceManager nm = this.createManager();
        for (i = 0; i < numbers.length; ++i) {
            for (j = 0; j < numbers.length; ++j) {
                Assert.assertTrue((boolean)nm.startOperation(numbers[i], numbers[j], this.createStoppable()));
            }
        }
        for (i = 0; i < numbers.length; ++i) {
            Assert.assertTrue((boolean)nm.startOperation(numbers[i], 0L, this.createStoppable()));
        }
        for (i = 0; i < numbers.length; ++i) {
            for (j = 0; j < numbers.length; ++j) {
                nm.endOperation(numbers[i], numbers[j], false);
                Assert.assertTrue((boolean)nm.startOperation(numbers[i], numbers[j], this.createStoppable()));
            }
        }
        for (i = 0; i < numbers.length; ++i) {
            for (j = 0; j < numbers.length; ++j) {
                nm.endOperation(numbers[i], numbers[j], true);
                Assert.assertEquals((Object)(numbers[j] == 0L ? 1 : 0), (Object)nm.startOperation(numbers[i], numbers[j], this.createStoppable()));
            }
        }
    }

    @Test
    public void testNoEndWithoutStart() {
        ServerNonceManager nm = this.createManager();
        try {
            nm.endOperation(0L, 1L, true);
            Assert.fail((String)"Should have thrown");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanup() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        try {
            ServerNonceManager nm = this.createManager(6);
            Chore cleanup = nm.createCleanupChore((Stoppable)Mockito.mock(Stoppable.class));
            edge.setValue(1L);
            Assert.assertTrue((boolean)nm.startOperation(0L, 1L, this.createStoppable()));
            Assert.assertTrue((boolean)nm.startOperation(0L, 2L, this.createStoppable()));
            Assert.assertTrue((boolean)nm.startOperation(0L, 3L, this.createStoppable()));
            edge.setValue(2L);
            nm.endOperation(0L, 1L, true);
            edge.setValue(4L);
            nm.endOperation(0L, 2L, true);
            edge.setValue(9L);
            cleanup.choreForTesting();
            Assert.assertTrue((boolean)nm.startOperation(0L, 1L, this.createStoppable()));
            Assert.assertFalse((boolean)nm.startOperation(0L, 2L, this.createStoppable()));
            nm.endOperation(0L, 3L, false);
            Assert.assertTrue((boolean)nm.startOperation(0L, 3L, this.createStoppable()));
            edge.setValue(11L);
            cleanup.choreForTesting();
            Assert.assertTrue((boolean)nm.startOperation(0L, 2L, this.createStoppable()));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWalNonces() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        try {
            ServerNonceManager nm = this.createManager(6);
            Chore cleanup = nm.createCleanupChore((Stoppable)Mockito.mock(Stoppable.class));
            edge.setValue(12L);
            nm.reportOperationFromWal(0L, 1L, 8L);
            nm.reportOperationFromWal(0L, 2L, 2L);
            nm.reportOperationFromWal(0L, 3L, 5L);
            nm.reportOperationFromWal(0L, 3L, 6L);
            Assert.assertFalse((boolean)nm.startOperation(0L, 1L, this.createStoppable()));
            Assert.assertTrue((boolean)nm.startOperation(0L, 2L, this.createStoppable()));
            Assert.assertFalse((boolean)nm.startOperation(0L, 3L, this.createStoppable()));
            edge.setValue(17L);
            cleanup.choreForTesting();
            Assert.assertFalse((boolean)nm.startOperation(0L, 1L, this.createStoppable()));
            Assert.assertFalse((boolean)nm.startOperation(0L, 3L, this.createStoppable()));
            edge.setValue(19L);
            cleanup.choreForTesting();
            Assert.assertTrue((boolean)nm.startOperation(0L, 1L, this.createStoppable()));
            Assert.assertTrue((boolean)nm.startOperation(0L, 3L, this.createStoppable()));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testConcurrentAttempts() throws Exception {
        ServerNonceManager nm = this.createManager();
        nm.startOperation(0L, 1L, this.createStoppable());
        TestRunnable tr = new TestRunnable(nm, 1L, false, this.createStoppable());
        Thread t = tr.start();
        this.waitForThreadToBlockOrExit(t);
        nm.endOperation(0L, 1L, true);
        t.join();
        tr.propagateError();
        nm.startOperation(0L, 2L, this.createStoppable());
        tr = new TestRunnable(nm, 2L, true, this.createStoppable());
        t = tr.start();
        this.waitForThreadToBlockOrExit(t);
        nm.endOperation(0L, 2L, false);
        t.join();
        tr.propagateError();
        nm.endOperation(0L, 2L, true);
        nm.startOperation(0L, 3L, this.createStoppable());
        tr = new TestRunnable(nm, 4L, true, this.createStoppable());
        tr.start().join();
        tr.propagateError();
    }

    @Test
    public void testStopWaiting() throws Exception {
        ServerNonceManager nm = this.createManager();
        nm.setConflictWaitIterationMs(1);
        Stoppable stoppingStoppable = this.createStoppable();
        Mockito.when((Object)stoppingStoppable.isStopped()).thenAnswer((Answer)new Answer<Boolean>(){
            AtomicInteger answer = new AtomicInteger(3);

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return 0 < this.answer.decrementAndGet();
            }
        });
        nm.startOperation(0L, 1L, this.createStoppable());
        TestRunnable tr = new TestRunnable(nm, 1L, null, stoppingStoppable);
        Thread t = tr.start();
        this.waitForThreadToBlockOrExit(t);
        t.join();
        tr.propagateError();
    }

    private void waitForThreadToBlockOrExit(Thread t) throws InterruptedException {
        for (int i = 9; i >= 0; --i) {
            if (t.getState() == Thread.State.TIMED_WAITING || t.getState() == Thread.State.WAITING || t.getState() == Thread.State.BLOCKED || t.getState() == Thread.State.TERMINATED) {
                return;
            }
            if (i <= 0) continue;
            Thread.sleep(300L);
        }
    }

    private Stoppable createStoppable() {
        Stoppable s = (Stoppable)Mockito.mock(Stoppable.class);
        Mockito.when((Object)s.isStopped()).thenReturn((Object)false);
        return s;
    }

    private ServerNonceManager createManager() {
        return this.createManager(null);
    }

    private ServerNonceManager createManager(Integer gracePeriod) {
        Configuration conf = HBaseConfiguration.create();
        if (gracePeriod != null) {
            conf.setInt("hbase.server.hashNonce.gracePeriod", gracePeriod.intValue());
        }
        return new ServerNonceManager(conf);
    }

    private static class TestRunnable
    implements Runnable {
        public final CountDownLatch startedLatch = new CountDownLatch(1);
        private final ServerNonceManager nm;
        private final long nonce;
        private final Boolean expected;
        private final Stoppable stoppable;
        private Throwable throwable = null;

        public TestRunnable(ServerNonceManager nm, long nonce, Boolean expected, Stoppable stoppable) {
            this.nm = nm;
            this.nonce = nonce;
            this.expected = expected;
            this.stoppable = stoppable;
        }

        public void propagateError() throws Exception {
            if (this.throwable == null) {
                return;
            }
            throw new Exception(this.throwable);
        }

        public Thread start() {
            Thread t = new Thread(this);
            t = Threads.setDaemonThreadRunning((Thread)t);
            try {
                this.startedLatch.await();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Unexpected");
            }
            return t;
        }

        @Override
        public void run() {
            boolean hasThrown;
            boolean shouldThrow;
            block4: {
                this.startedLatch.countDown();
                shouldThrow = this.expected == null;
                hasThrown = true;
                try {
                    boolean result = this.nm.startOperation(0L, this.nonce, this.stoppable);
                    hasThrown = false;
                    if (!shouldThrow) {
                        Assert.assertEquals((Object)this.expected, (Object)result);
                    }
                }
                catch (Throwable t) {
                    if (shouldThrow) break block4;
                    this.throwable = t;
                }
            }
            if (shouldThrow && !hasThrown) {
                this.throwable = new AssertionError((Object)"Should have thrown");
            }
        }
    }
}

