/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestPutWithDelete {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHbasePutDeleteCell() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestPutWithDelete");
        byte[] rowKey = Bytes.toBytes((String)"12345");
        byte[] family = Bytes.toBytes((String)"cf");
        HTable table = TEST_UTIL.createTable(tableName, family);
        TEST_UTIL.waitTableAvailable(tableName.getName(), 5000L);
        try {
            Put put = new Put(rowKey);
            put.add(family, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
            put.add(family, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
            put.add(family, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c"));
            table.put(put);
            Get get = new Get(rowKey);
            Result result = table.get(get);
            Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"A"))).equals("a"));
            Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"B"))).equals("b"));
            Assert.assertTrue((String)"Column C value should be c", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"C"))).equals("c"));
            put = new Put(rowKey);
            put.add(family, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a"));
            put.add(family, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b"));
            KeyValue marker = new KeyValue(rowKey, family, Bytes.toBytes((String)"C"), Long.MAX_VALUE, KeyValue.Type.DeleteColumn);
            put.add((Cell)marker);
            table.put(put);
            get = new Get(rowKey);
            result = table.get(get);
            Assert.assertTrue((String)"Column A value should be a", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"A"))).equals("a"));
            Assert.assertTrue((String)"Column B value should be b", (boolean)Bytes.toString((byte[])result.getValue(family, Bytes.toBytes((String)"B"))).equals("b"));
            Assert.assertTrue((String)"Column C should not exist", (result.getValue(family, Bytes.toBytes((String)"C")) == null ? 1 : 0) != 0);
        }
        finally {
            table.close();
        }
    }
}

