/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;

@InterfaceAudience.Private
public class RESTServletContainer
extends ServletContainer {
    private static final long serialVersionUID = -2474255003443394314L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String doAsUserFromQuery = request.getParameter("doAs");
        RESTServlet servlet = RESTServlet.getInstance();
        if (doAsUserFromQuery != null) {
            Configuration conf = servlet.getConfiguration();
            if (!servlet.supportsProxyuser()) {
                throw new ServletException("Support for proxyuser is not configured");
            }
            UserGroupInformation ugi = servlet.getRealUser();
            ugi = UserGroupInformation.createProxyUser((String)doAsUserFromQuery, (UserGroupInformation)ugi);
            try {
                ProxyUsers.authorize((UserGroupInformation)ugi, (String)request.getRemoteAddr(), (Configuration)conf);
            }
            catch (AuthorizationException e) {
                throw new ServletException(e.getMessage());
            }
            servlet.setEffectiveUser(doAsUserFromQuery);
        } else {
            String effectiveUser = request.getRemoteUser();
            servlet.setEffectiveUser(effectiveUser);
        }
        super.service(request, response);
    }
}

