/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV3;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPrefetch {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final int NUM_KV = 1000;
    private static final Random RNG = new Random();
    private Configuration conf;
    private CacheConfig cacheConf;
    private FileSystem fs;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.fs = HFileSystem.get((Configuration)this.conf);
        this.cacheConf = new CacheConfig(this.conf);
    }

    @Test(timeout=60000L)
    public void testPrefetch() throws Exception {
        Path storeFile = this.writeStoreFile();
        this.readStoreFile(storeFile);
    }

    private void readStoreFile(Path storeFilePath) throws Exception {
        HFileBlock block;
        HFileReaderV2 reader = (HFileReaderV2)HFile.createReader((FileSystem)this.fs, (Path)storeFilePath, (CacheConfig)this.cacheConf, (Configuration)this.conf);
        while (!((HFileReaderV3)reader).prefetchComplete()) {
            Thread.sleep(1000L);
        }
        BlockCache blockCache = this.cacheConf.getBlockCache();
        HFileBlock prevBlock = null;
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            boolean isCached;
            long onDiskSize = -1L;
            if (prevBlock != null) {
                onDiskSize = prevBlock.getNextBlockOnDiskSizeWithHeader();
            }
            block = reader.readBlock(offset, onDiskSize, false, true, false, true, null);
            BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
            boolean bl = isCached = blockCache.getBlock(blockCacheKey, true, false, true) != null;
            if (block.getBlockType() == BlockType.DATA || block.getBlockType() == BlockType.ROOT_INDEX || block.getBlockType() == BlockType.INTERMEDIATE_INDEX) {
                Assert.assertTrue((boolean)isCached);
            }
            prevBlock = block;
        }
    }

    private Path writeStoreFile() throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), "TestPrefetch");
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFile.Writer sfw = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withOutputDir(storeFileParentDir).withComparator(KeyValue.COMPARATOR).withFileContext(meta).build();
        int rowLen = 32;
        for (int i = 0; i < 1000; ++i) {
            byte[] k = TestHFileWriterV2.randomOrderedKey(RNG, i);
            byte[] v = TestHFileWriterV2.randomValue(RNG);
            int cfLen = RNG.nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, RNG.nextLong(), TestPrefetch.generateKeyType(RNG), v, 0, v.length);
            sfw.append(kv);
        }
        sfw.close();
        return sfw.getPath();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". " + "Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }
}

