/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.DefaultScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class VisibilityUtils {
    public static final String VISIBILITY_LABEL_GENERATOR_CLASS = "hbase.regionserver.scan.visibility.label.generator.class";
    public static final byte VISIBILITY_TAG_TYPE = 2;
    public static final byte VISIBILITY_EXP_SERIALIZATION_TAG_TYPE = 4;
    public static final String SYSTEM_LABEL = "system";
    public static final Tag VIS_SERIALIZATION_TAG = new Tag(4, VisibilityConstants.SORTED_ORDINAL_SERIALIZATION_FORMAT);
    private static final String COMMA = ",";

    public static byte[] getDataToWriteToZooKeeper(Map<String, Integer> existingLabels) {
        VisibilityLabelsProtos.VisibilityLabelsRequest.Builder visReqBuilder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
        for (Map.Entry<String, Integer> entry : existingLabels.entrySet()) {
            VisibilityLabelsProtos.VisibilityLabel.Builder visLabBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
            visLabBuilder.setLabel(ByteStringer.wrap((byte[])Bytes.toBytes((String)entry.getKey())));
            visLabBuilder.setOrdinal(entry.getValue().intValue());
            visReqBuilder.addVisLabel(visLabBuilder.build());
        }
        return ProtobufUtil.prependPBMagic((byte[])visReqBuilder.build().toByteArray());
    }

    public static byte[] getUserAuthsDataToWriteToZooKeeper(Map<String, List<Integer>> userAuths) {
        VisibilityLabelsProtos.MultiUserAuthorizations.Builder builder = VisibilityLabelsProtos.MultiUserAuthorizations.newBuilder();
        for (Map.Entry<String, List<Integer>> entry : userAuths.entrySet()) {
            VisibilityLabelsProtos.UserAuthorizations.Builder userAuthsBuilder = VisibilityLabelsProtos.UserAuthorizations.newBuilder();
            userAuthsBuilder.setUser(ByteStringer.wrap((byte[])Bytes.toBytes((String)entry.getKey())));
            for (Integer label : entry.getValue()) {
                userAuthsBuilder.addAuth(label.intValue());
            }
            builder.addUserAuths(userAuthsBuilder.build());
        }
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    public static List<VisibilityLabelsProtos.VisibilityLabel> readLabelsFromZKData(byte[] data) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix((byte[])data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                VisibilityLabelsProtos.VisibilityLabelsRequest request = ((VisibilityLabelsProtos.VisibilityLabelsRequest.Builder)VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder().mergeFrom(data, pblen, data.length - pblen)).build();
                return request.getVisLabelList();
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        return null;
    }

    public static VisibilityLabelsProtos.MultiUserAuthorizations readUserAuthsFromZKData(byte[] data) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix((byte[])data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                VisibilityLabelsProtos.MultiUserAuthorizations multiUserAuths = ((VisibilityLabelsProtos.MultiUserAuthorizations.Builder)VisibilityLabelsProtos.MultiUserAuthorizations.newBuilder().mergeFrom(data, pblen, data.length - pblen)).build();
                return multiUserAuths;
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        return null;
    }

    public static List<ScanLabelGenerator> getScanLabelGenerators(Configuration conf) throws IOException {
        String slgClassesCommaSeparated = conf.get(VISIBILITY_LABEL_GENERATOR_CLASS);
        ArrayList<ScanLabelGenerator> slgs = new ArrayList<ScanLabelGenerator>();
        if (StringUtils.isNotEmpty((String)slgClassesCommaSeparated)) {
            String[] slgClasses;
            for (String slgClass : slgClasses = slgClassesCommaSeparated.split(COMMA)) {
                try {
                    Class slgKlass = conf.getClassByName(slgClass.trim());
                    slgs.add((ScanLabelGenerator)ReflectionUtils.newInstance((Class)slgKlass, (Configuration)conf));
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
        }
        if (slgs.isEmpty()) {
            slgs.add((ScanLabelGenerator)ReflectionUtils.newInstance(DefaultScanLabelGenerator.class, (Configuration)conf));
        }
        return slgs;
    }

    public static boolean getVisibilityTags(Cell cell, List<Tag> tags) {
        boolean sortedOrder = false;
        Iterator tagsIterator = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
        while (tagsIterator.hasNext()) {
            byte serializationVersion;
            Tag tag = (Tag)tagsIterator.next();
            if (tag.getType() == 4 && (serializationVersion = tag.getBuffer()[tag.getTagOffset()]) == 1) {
                sortedOrder = true;
                continue;
            }
            if (tag.getType() != 2) continue;
            tags.add(tag);
        }
        return sortedOrder;
    }

    public static boolean isVisibilityTagsPresent(Cell cell) {
        Iterator tagsIterator = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
        while (tagsIterator.hasNext()) {
            Tag tag = (Tag)tagsIterator.next();
            if (tag.getType() != 2) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForMatchingVisibilityTags(Cell cell, List<Tag> visibilityTagsInDeleteCell) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        boolean sortedTags = VisibilityUtils.getVisibilityTags(cell, tags);
        if (tags.size() == 0) {
            return false;
        }
        if (sortedTags) {
            return VisibilityUtils.checkForMatchingVisibilityTagsWithSortedOrder(visibilityTagsInDeleteCell, tags);
        }
        try {
            return VisibilityUtils.checkForMatchingVisibilityTagsWithOutSortedOrder(cell, visibilityTagsInDeleteCell);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while sorting the tags from the cell", e);
        }
    }

    private static boolean checkForMatchingVisibilityTagsWithOutSortedOrder(Cell cell, List<Tag> visibilityTagsInDeleteCell) throws IOException {
        List<List<Integer>> sortedDeleteTags = VisibilityUtils.sortTagsBasedOnOrdinal(visibilityTagsInDeleteCell);
        List<List<Integer>> sortedTags = VisibilityUtils.sortTagsBasedOnOrdinal(cell);
        return VisibilityUtils.compareTagsOrdinals(sortedDeleteTags, sortedTags);
    }

    private static boolean checkForMatchingVisibilityTagsWithSortedOrder(List<Tag> visibilityTagsInDeleteCell, List<Tag> tags) {
        boolean matchFound = false;
        if (visibilityTagsInDeleteCell.size() != tags.size()) {
            return matchFound;
        }
        block0: for (Tag tag : visibilityTagsInDeleteCell) {
            matchFound = false;
            for (Tag givenTag : tags) {
                if (!Bytes.equals((byte[])tag.getBuffer(), (int)tag.getTagOffset(), (int)tag.getTagLength(), (byte[])givenTag.getBuffer(), (int)givenTag.getTagOffset(), (int)givenTag.getTagLength())) continue;
                matchFound = true;
                continue block0;
            }
        }
        return matchFound;
    }

    private static List<List<Integer>> sortTagsBasedOnOrdinal(Cell cell) throws IOException {
        Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
        ArrayList<List<Integer>> fullTagsList = new ArrayList<List<Integer>>();
        while (tagsItr.hasNext()) {
            Tag tag = (Tag)tagsItr.next();
            if (tag.getType() != 2) continue;
            VisibilityUtils.getSortedTagOrdinals(fullTagsList, tag);
        }
        return fullTagsList;
    }

    private static List<List<Integer>> sortTagsBasedOnOrdinal(List<Tag> tags) throws IOException {
        ArrayList<List<Integer>> fullTagsList = new ArrayList<List<Integer>>();
        for (Tag tag : tags) {
            if (tag.getType() != 2) continue;
            VisibilityUtils.getSortedTagOrdinals(fullTagsList, tag);
        }
        return fullTagsList;
    }

    private static void getSortedTagOrdinals(List<List<Integer>> fullTagsList, Tag tag) throws IOException {
        Pair result;
        int offset;
        ArrayList<Object> tagsOrdinalInSortedOrder = new ArrayList<Object>();
        int endOffset = offset + tag.getTagLength();
        for (offset = tag.getTagOffset(); offset < endOffset; offset += ((Integer)result.getSecond()).intValue()) {
            result = StreamUtils.readRawVarint32((byte[])tag.getBuffer(), (int)offset);
            tagsOrdinalInSortedOrder.add(result.getFirst());
        }
        Collections.sort(tagsOrdinalInSortedOrder);
        fullTagsList.add(tagsOrdinalInSortedOrder);
    }

    private static boolean compareTagsOrdinals(List<List<Integer>> tagsInDeletes, List<List<Integer>> tags) {
        boolean matchFound = false;
        if (tagsInDeletes.size() != tags.size()) {
            return matchFound;
        }
        block0: for (List<Integer> deleteTagOrdinals : tagsInDeletes) {
            matchFound = false;
            for (List<Integer> tagOrdinals : tags) {
                if (!((Object)deleteTagOrdinals).equals(tagOrdinals)) continue;
                matchFound = true;
                continue block0;
            }
        }
        return matchFound;
    }
}

