/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SimpleByteRange;

@InterfaceAudience.Private
class VisibilityLabelFilter
extends FilterBase {
    private final BitSet authLabels;
    private final Map<ByteRange, Integer> cfVsMaxVersions;
    private final ByteRange curFamily;
    private final ByteRange curQualifier;
    private int curFamilyMaxVersions;
    private int curQualMetVersions;

    public VisibilityLabelFilter(BitSet authLabels, Map<ByteRange, Integer> cfVsMaxVersions) {
        this.authLabels = authLabels;
        this.cfVsMaxVersions = cfVsMaxVersions;
        this.curFamily = new SimpleByteRange();
        this.curQualifier = new SimpleByteRange();
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        if (this.curFamily.getBytes() == null || Bytes.compareTo((byte[])this.curFamily.getBytes(), (int)this.curFamily.getOffset(), (int)this.curFamily.getLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()) != 0) {
            this.curFamily.set(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
            this.curFamilyMaxVersions = this.cfVsMaxVersions.get(this.curFamily);
            this.curQualifier.unset();
        }
        if (this.curQualifier.getBytes() == null || Bytes.compareTo((byte[])this.curQualifier.getBytes(), (int)this.curQualifier.getOffset(), (int)this.curQualifier.getLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) != 0) {
            this.curQualifier.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.curQualMetVersions = 0;
        }
        ++this.curQualMetVersions;
        if (this.curQualMetVersions > this.curFamilyMaxVersions) {
            return Filter.ReturnCode.SKIP;
        }
        Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
        boolean visibilityTagPresent = false;
        while (tagsItr.hasNext()) {
            Pair result;
            int offset;
            boolean includeKV = true;
            Tag tag = (Tag)tagsItr.next();
            if (tag.getType() != 2) continue;
            visibilityTagPresent = true;
            int endOffset = offset + tag.getTagLength();
            for (offset = tag.getTagOffset(); offset < endOffset; offset += ((Integer)result.getSecond()).intValue()) {
                result = StreamUtils.readRawVarint32((byte[])tag.getBuffer(), (int)offset);
                int currLabelOrdinal = (Integer)result.getFirst();
                if (currLabelOrdinal < 0) {
                    int temp = -currLabelOrdinal;
                    if (!this.authLabels.get(temp)) continue;
                    includeKV = false;
                    break;
                }
                if (this.authLabels.get(currLabelOrdinal)) continue;
                includeKV = false;
                break;
            }
            if (!includeKV) continue;
            return Filter.ReturnCode.INCLUDE;
        }
        return visibilityTagPresent ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
    }

    public void reset() throws IOException {
        this.curFamily.unset();
        this.curQualifier.unset();
        this.curFamilyMaxVersions = 0;
        this.curQualMetVersions = 0;
    }
}

