/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class LabelExpander {
    private Configuration conf;
    private ExpressionParser parser = new ExpressionParser();
    private ExpressionExpander expander = new ExpressionExpander();
    private Map<String, Integer> labels;

    public LabelExpander(Configuration conf) {
        this.conf = conf;
    }

    private List<Tag> createVisibilityTags(String visibilityLabelsExp) throws IOException, ParseException, InvalidLabelException {
        ExpressionNode node = null;
        node = this.parser.parse(visibilityLabelsExp);
        node = this.expander.expand(node);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ArrayList<Integer> labelOrdinals = new ArrayList<Integer>();
        tags.add(VisibilityUtils.VIS_SERIALIZATION_TAG);
        if (node.isSingleNode()) {
            this.getLabelOrdinals(node, labelOrdinals);
            this.writeLabelOrdinalsToStream(labelOrdinals, dos);
            tags.add(new Tag(2, baos.toByteArray()));
            baos.reset();
        } else {
            NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
            if (nlNode.getOperator() == Operator.OR) {
                for (ExpressionNode child : nlNode.getChildExps()) {
                    this.getLabelOrdinals(child, labelOrdinals);
                    this.writeLabelOrdinalsToStream(labelOrdinals, dos);
                    tags.add(new Tag(2, baos.toByteArray()));
                    baos.reset();
                    labelOrdinals.clear();
                }
            } else {
                this.getLabelOrdinals(nlNode, labelOrdinals);
                this.writeLabelOrdinalsToStream(labelOrdinals, dos);
                tags.add(new Tag(2, baos.toByteArray()));
                baos.reset();
            }
        }
        return tags;
    }

    private void writeLabelOrdinalsToStream(List<Integer> labelOrdinals, DataOutputStream dos) throws IOException {
        Collections.sort(labelOrdinals);
        for (Integer labelOrdinal : labelOrdinals) {
            StreamUtils.writeRawVInt32((OutputStream)dos, (int)labelOrdinal);
        }
    }

    private void getLabelOrdinals(ExpressionNode node, List<Integer> labelOrdinals) throws IOException, InvalidLabelException {
        if (node.isSingleNode()) {
            String identifier = null;
            int labelOrdinal = 0;
            if (node instanceof LeafExpressionNode) {
                identifier = ((LeafExpressionNode)node).getIdentifier();
                labelOrdinal = this.labels.get(identifier);
            } else {
                LeafExpressionNode lNode = (LeafExpressionNode)((NonLeafExpressionNode)node).getChildExps().get(0);
                identifier = lNode.getIdentifier();
                labelOrdinal = this.labels.get(identifier);
                labelOrdinal = -1 * labelOrdinal;
            }
            if (labelOrdinal == 0) {
                throw new InvalidLabelException("Invalid visibility label " + identifier);
            }
            labelOrdinals.add(labelOrdinal);
        } else {
            List<ExpressionNode> childExps = ((NonLeafExpressionNode)node).getChildExps();
            for (ExpressionNode child : childExps) {
                this.getLabelOrdinals(child, labelOrdinals);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLabels() throws IOException {
        HTable visibilityLabelsTable = null;
        ResultScanner scanner = null;
        try {
            Result next;
            this.labels = new HashMap<String, Integer>();
            visibilityLabelsTable = new HTable(this.conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
            Scan scan = new Scan();
            scan.setAuthorizations(new Authorizations(new String[]{"system"}));
            scan.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
            scanner = visibilityLabelsTable.getScanner(scan);
            while ((next = scanner.next()) != null) {
                byte[] row = next.getRow();
                byte[] value = next.getValue(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                this.labels.put(Bytes.toString((byte[])value), Bytes.toInt((byte[])row));
            }
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
            }
            finally {
                if (visibilityLabelsTable != null) {
                    visibilityLabelsTable.close();
                }
            }
        }
    }

    public KeyValue createKVFromCellVisibilityExpr(int rowKeyOffset, int rowKeyLength, byte[] family, int familyOffset, int familyLength, byte[] qualifier, int qualifierOffset, int qualifierLength, long ts, KeyValue.Type put, byte[] lineBytes, int columnOffset, int columnLength, String cellVisibilityExpr) throws IOException, ImportTsv.TsvParser.BadTsvLineException {
        if (this.labels == null && cellVisibilityExpr != null) {
            this.createLabels();
        }
        KeyValue kv = null;
        if (cellVisibilityExpr != null) {
            try {
                List<Tag> visibilityTags = this.createVisibilityTags(cellVisibilityExpr);
                kv = new KeyValue(lineBytes, rowKeyOffset, rowKeyLength, family, familyOffset, familyLength, qualifier, qualifierOffset, qualifierLength, ts, KeyValue.Type.Put, lineBytes, columnOffset, columnLength, visibilityTags);
            }
            catch (ParseException e) {
                throw new ImportTsv.TsvParser.BadTsvLineException("Parse Exception " + e.getMessage());
            }
        } else {
            kv = new KeyValue(lineBytes, rowKeyOffset, rowKeyLength, family, familyOffset, familyLength, qualifier, qualifierOffset, qualifierLength, ts, KeyValue.Type.Put, lineBytes, columnOffset, columnLength);
        }
        return kv;
    }
}

