/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ListMultimap;
import com.google.protobuf.BlockingRpcChannel;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestNamespaceCommands
extends SecureTestUtil {
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String TestNamespace = "ns1";
    private static Configuration conf;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static User SUPERUSER;
    private static User USER_RW;
    private static User USER_CREATE;
    private static User USER_NSP_WRITE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        TestNamespaceCommands.enableSecurity(conf);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rw_user", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"create_user", (String[])new String[0]);
        USER_NSP_WRITE = User.createUserForTesting((Configuration)conf, (String)"namespace_write", (String[])new String[0]);
        UTIL.startMiniCluster();
        UTIL.waitTableAvailable(AccessControlLists.ACL_TABLE_NAME.getName(), 30000L);
        ACCESS_CONTROLLER = (AccessController)UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost().findCoprocessor(AccessController.class.getName());
        UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)TestNamespace).build());
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NSP_WRITE.getShortName(), TestNamespace, Permission.Action.WRITE);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.getHBaseAdmin().deleteNamespace(TestNamespace);
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAclTableEntries() throws Exception {
        String userTestNamespace = "userTestNsp";
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            TestNamespaceCommands.grantOnNamespace(UTIL, userTestNamespace, TestNamespace, Permission.Action.WRITE);
            Result result = acl.get(new Get(Bytes.toBytes((String)userTestNamespace)));
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            ListMultimap perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TestNamespace);
            Assert.assertEquals((long)2L, (long)perms.size());
            List namespacePerms = perms.get((Object)userTestNamespace);
            Assert.assertTrue((boolean)perms.containsKey((Object)userTestNamespace));
            Assert.assertEquals((long)1L, (long)namespacePerms.size());
            Assert.assertEquals((Object)TestNamespace, (Object)((TablePermission)namespacePerms.get(0)).getNamespace());
            Assert.assertEquals(null, (Object)((TablePermission)namespacePerms.get(0)).getFamily());
            Assert.assertEquals(null, (Object)((TablePermission)namespacePerms.get(0)).getQualifier());
            Assert.assertEquals((long)1L, (long)((TablePermission)namespacePerms.get(0)).getActions().length);
            Assert.assertEquals((Object)Permission.Action.WRITE, (Object)((TablePermission)namespacePerms.get(0)).getActions()[0]);
            TestNamespaceCommands.revokeFromNamespace(UTIL, userTestNamespace, TestNamespace, Permission.Action.WRITE);
            perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TestNamespace);
            Assert.assertEquals((long)1L, (long)perms.size());
        }
        finally {
            acl.close();
        }
    }

    @Test
    public void testModifyNamespace() throws Exception {
        SecureTestUtil.AccessTestAction modifyNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), NamespaceDescriptor.create((String)TestNamespace).addConfiguration("abc", "156").build());
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(modifyNamespace, SUPERUSER);
        TestNamespaceCommands.verifyDenied(modifyNamespace, USER_NSP_WRITE, USER_CREATE, USER_RW);
    }

    @Test
    public void testGrantRevoke() throws Exception {
        String testUser = "testUser";
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)"testUser", (String)TestNamespace, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)"testUser", (String)TestNamespace, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(grantAction, SUPERUSER);
        TestNamespaceCommands.verifyDenied(grantAction, USER_CREATE, USER_RW);
        TestNamespaceCommands.verifyAllowed(revokeAction, SUPERUSER);
        TestNamespaceCommands.verifyDenied(revokeAction, USER_CREATE, USER_RW);
    }
}

