/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerMetrics {
    private static final Log LOG = LogFactory.getLog(TestRegionServerMetrics.class);
    private static MetricsAssertHelper metricsHelper;
    private static MiniHBaseCluster cluster;
    private static HRegionServer rs;
    private static Configuration conf;
    private static HBaseTestingUtility TEST_UTIL;
    private static MetricsRegionServer metricsRegionServer;
    private static MetricsRegionServerSource serverSource;

    @BeforeClass
    public static void startCluster() throws Exception {
        metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.getLong("hbase.splitlog.max.resubmit", 0L);
        conf.setInt("zookeeper.recovery.retry", 0);
        conf.setInt("hbase.regionserver.info.port", -1);
        TEST_UTIL.startMiniCluster(1, 1);
        cluster = TEST_UTIL.getHBaseCluster();
        cluster.waitForActiveAndReadyMaster();
        while (cluster.getLiveRegionServerThreads().size() < 1) {
            Threads.sleep((long)100L);
        }
        rs = cluster.getRegionServer(0);
        metricsRegionServer = rs.getMetrics();
        serverSource = metricsRegionServer.getMetricsSource();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test(timeout=300000L)
    public void testRegionCount() throws Exception {
        String regionMetricsKey = "regionCount";
        long regions = metricsHelper.getGaugeLong(regionMetricsKey, (BaseSource)serverSource);
        TEST_UTIL.createTable(Bytes.toBytes((String)"table"), Bytes.toBytes((String)"cf"));
        metricsHelper.assertGaugeGt(regionMetricsKey, regions, (BaseSource)serverSource);
    }

    @Test
    public void testLocalFiles() throws Exception {
        metricsHelper.assertGauge("percentFilesLocal", 0L, (BaseSource)serverSource);
    }

    @Test
    public void testRequestCount() throws Exception {
        int i;
        String tableNameString = "testRequestCount";
        byte[] tName = Bytes.toBytes((String)tableNameString);
        byte[] cfName = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] initValue = Bytes.toBytes((String)"Value");
        byte[] nextValue = Bytes.toBytes((String)"NEXT VAL");
        TEST_UTIL.createTable(tName, cfName);
        new HTable(conf, tName).close();
        HTable table = new HTable(conf, tName);
        Put p = new Put(row);
        p.add(cfName, qualifier, initValue);
        table.put(p);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long requests = metricsHelper.getCounter("totalRequestCount", (BaseSource)serverSource);
        long readRequests = metricsHelper.getCounter("readRequestCount", (BaseSource)serverSource);
        long writeRequests = metricsHelper.getCounter("writeRequestCount", (BaseSource)serverSource);
        for (int i2 = 0; i2 < 30; ++i2) {
            table.put(p);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 30L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        Get g = new Get(row);
        for (int i3 = 0; i3 < 10; ++i3) {
            table.get(g);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 40L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 10L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        for (HRegionInfo i4 : table.getRegionLocations().keySet()) {
            MetricsRegionAggregateSource agg = rs.getRegion(i4.getRegionName()).getMetrics().getSource().getAggregateSource();
            String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i4.getEncodedName() + "_metric";
            metricsHelper.assertCounter(prefix + "_getNumOps", 10L, (BaseSource)agg);
            metricsHelper.assertCounter(prefix + "_mutateCount", 31L, (BaseSource)agg);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 40L + 3L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 10L + 1L, (BaseSource)serverSource);
        ArrayList<Get> gets = new ArrayList<Get>();
        for (i = 0; i < 10; ++i) {
            gets.add(new Get(row));
        }
        table.get(gets);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 50L + 3L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 20L + 1L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        table.setAutoFlushTo(false);
        for (i = 0; i < 30; ++i) {
            table.put(p);
        }
        table.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 80L + 3L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 20L + 1L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 60L, (BaseSource)serverSource);
        table.close();
    }

    @Test
    public void testMutationsWithoutWal() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testMutationsWithoutWal");
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        p.setDurability(Durability.SKIP_WAL);
        t.put(p);
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("mutationsWithoutWALCount", 1L, (BaseSource)serverSource);
        long minLength = row.length + cf.length + qualifier.length + val.length;
        metricsHelper.assertGaugeGt("mutationsWithoutWALSize", minLength, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testStoreCount() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testStoreCount");
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long stores = metricsHelper.getGaugeLong("storeCount", (BaseSource)serverSource);
        long storeFiles = metricsHelper.getGaugeLong("storeFileCount", (BaseSource)serverSource);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        t.flushCommits();
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("storeCount", stores + 1L, (BaseSource)serverSource);
        metricsHelper.assertGauge("storeFileCount", storeFiles + 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testCheckAndPutCount() throws Exception {
        String tableNameString = "testCheckAndPutCount";
        byte[] tableName = Bytes.toBytes((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] valOne = Bytes.toBytes((String)"Value");
        byte[] valTwo = Bytes.toBytes((String)"ValueTwo");
        byte[] valThree = Bytes.toBytes((String)"ValueThree");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, valOne);
        t.put(p);
        t.flushCommits();
        Put pTwo = new Put(row);
        pTwo.add(cf, qualifier, valTwo);
        t.checkAndPut(row, cf, qualifier, valOne, pTwo);
        t.flushCommits();
        Put pThree = new Put(row);
        pThree.add(cf, qualifier, valThree);
        t.checkAndPut(row, cf, qualifier, valOne, pThree);
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("checkMutateFailedCount", 1L, (BaseSource)serverSource);
        metricsHelper.assertCounter("checkMutatePassedCount", 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testIncrement() throws Exception {
        String tableNameString = "testIncrement";
        byte[] tableName = Bytes.toBytes((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((long)0L);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        t.flushCommits();
        for (int count = 0; count < 13; ++count) {
            Increment inc = new Increment(row);
            inc.addColumn(cf, qualifier, 100L);
            t.increment(inc);
        }
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("incrementNumOps", 13L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testAppend() throws Exception {
        String tableNameString = "testAppend";
        byte[] tableName = Bytes.toBytes((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"One");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        t.flushCommits();
        for (int count = 0; count < 73; ++count) {
            Append append = new Append(row);
            append.add(cf, qualifier, Bytes.toBytes((String)",Test"));
            t.append(append);
        }
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("appendNumOps", 73L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testScanNext() throws IOException {
        String tableNameString = "testScanNext";
        byte[] tableName = Bytes.toBytes((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"One");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        t.setAutoFlush(false, true);
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes((String)("" + insertCount + "row")));
            p.add(cf, qualifier, val);
            t.put(p);
        }
        t.flushCommits();
        Scan s = new Scan();
        s.setBatch(1);
        s.setCaching(1);
        ResultScanner resultScanners = t.getScanner(s);
        for (int nextCount = 0; nextCount < 30; ++nextCount) {
            Result result = resultScanners.next();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)1L, (long)result.size());
        }
        for (HRegionInfo i : t.getRegionLocations().keySet()) {
            MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
            String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
            metricsHelper.assertCounter(prefix + "_scanNextNumOps", 30L, (BaseSource)agg);
        }
    }

    static {
        Logger.getLogger((String)"org.apache.hadoop.hbase").setLevel(Level.DEBUG);
    }
}

