/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestHBaseTestingUtility {
    private final Log LOG = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testMultiClusters() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        htu1.getConfiguration().set("zookeeper.znode.parent", "/1");
        htu1.startMiniZKCluster();
        HBaseTestingUtility htu2 = new HBaseTestingUtility();
        htu2.getConfiguration().set("zookeeper.znode.parent", "/2");
        htu2.getConfiguration().set("hbase.zookeeper.property.clientPort", htu1.getConfiguration().get("hbase.zookeeper.property.clientPort", "-1"));
        htu2.setZkCluster(htu1.getZkCluster());
        HBaseTestingUtility htu3 = new HBaseTestingUtility();
        htu3.getConfiguration().set("zookeeper.znode.parent", "/3");
        htu3.getConfiguration().set("hbase.zookeeper.property.clientPort", htu1.getConfiguration().get("hbase.zookeeper.property.clientPort", "-1"));
        htu3.setZkCluster(htu1.getZkCluster());
        try {
            htu1.startMiniCluster();
            htu2.startMiniCluster();
            htu3.startMiniCluster();
            byte[] TABLE_NAME = Bytes.toBytes((String)"test");
            byte[] FAM_NAME = Bytes.toBytes((String)"fam");
            byte[] ROW = Bytes.toBytes((String)"row");
            byte[] QUAL_NAME = Bytes.toBytes((String)"qual");
            byte[] VALUE = Bytes.toBytes((String)"value");
            HTable table1 = htu1.createTable(TABLE_NAME, FAM_NAME);
            HTable table2 = htu2.createTable(TABLE_NAME, FAM_NAME);
            Put put = new Put(ROW);
            put.add(FAM_NAME, QUAL_NAME, VALUE);
            table1.put(put);
            Get get = new Get(ROW);
            get.addColumn(FAM_NAME, QUAL_NAME);
            Result res = table1.get(get);
            Assert.assertEquals((long)1L, (long)res.size());
            res = table2.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
            table1.close();
            table2.close();
        }
        finally {
            htu3.shutdownMiniCluster();
            htu2.shutdownMiniCluster();
            htu1.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniCluster() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    @Test
    public void testMultipleStartStop() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        Path foo = new Path("foo");
        htu1.startMiniCluster();
        htu1.getDFSCluster().getFileSystem().create(foo);
        Assert.assertTrue((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.shutdownMiniCluster();
        htu1.startMiniCluster();
        Assert.assertFalse((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.getDFSCluster().getFileSystem().create(foo);
        Assert.assertTrue((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniZooKeeper() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniZooKeeperCluster cluster1 = hbt.startMiniZKCluster();
        try {
            Assert.assertEquals((long)0L, (long)cluster1.getBackupZooKeeperServerNum());
            Assert.assertTrue((cluster1.killCurrentActiveZooKeeperServer() == -1 ? 1 : 0) != 0);
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        MiniZooKeeperCluster cluster2 = hbt.startMiniZKCluster(5);
        int defaultClientPort = 21818;
        cluster2.setDefaultClientPort(defaultClientPort);
        try {
            Assert.assertEquals((long)4L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertTrue((cluster2.killCurrentActiveZooKeeperServer() >= defaultClientPort ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.killCurrentActiveZooKeeperServer() >= defaultClientPort ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)3L, (long)cluster2.getZooKeeperServerNum());
            cluster2.killOneBackupZooKeeperServer();
            cluster2.killOneBackupZooKeeperServer();
            Assert.assertEquals((long)0L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)1L, (long)cluster2.getZooKeeperServerNum());
            Assert.assertTrue((cluster2.killCurrentActiveZooKeeperServer() == -1 ? 1 : 0) != 0);
            cluster2.killOneBackupZooKeeperServer();
            Assert.assertEquals((long)-1L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)0L, (long)cluster2.getZooKeeperServerNum());
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    @Test
    public void testMiniDFSCluster() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniDFSCluster cluster = hbt.startMiniDFSCluster(null);
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path dir = new Path("dir");
        Path qualifiedDir = dfs.makeQualified(dir);
        this.LOG.info((Object)("dir=" + dir + ", qualifiedDir=" + qualifiedDir));
        Assert.assertFalse((boolean)dfs.exists(qualifiedDir));
        Assert.assertTrue((boolean)dfs.mkdirs(qualifiedDir));
        Assert.assertTrue((boolean)dfs.delete(qualifiedDir, true));
        hbt.shutdownMiniCluster();
    }

    @Test
    public void testSetupClusterTestBuildDir() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        Path testdir = hbt.getClusterTestDir();
        this.LOG.info((Object)("uuid-subdir=" + testdir));
        FileSystem fs = hbt.getTestFileSystem();
        Assert.assertFalse((boolean)fs.exists(testdir));
        hbt.startMiniDFSCluster(null);
        Assert.assertTrue((boolean)fs.exists(testdir));
        hbt.shutdownMiniCluster();
        Assert.assertFalse((boolean)fs.exists(testdir));
    }

    @Test
    public void testTestDir() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        Path testdir = hbt.getDataTestDir();
        this.LOG.info((Object)("testdir=" + testdir));
        FileSystem fs = hbt.getTestFileSystem();
        Assert.assertTrue((!fs.exists(testdir) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.mkdirs(testdir));
        Assert.assertTrue((boolean)hbt.cleanupTestDir());
    }
}

