/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import com.google.common.collect.Lists;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.snapshot.DisabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestSnapshotFromMaster {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFromMaster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static Path rootDir;
    private static Path snapshots;
    private static FileSystem fs;
    private static HMaster master;
    private static Path archiveDir;
    private static final byte[] TEST_FAM;
    private static final TableName TABLE_NAME;
    private static final long cacheRefreshPeriod = 500L;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotFromMaster.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
        fs = UTIL.getDFSCluster().getFileSystem();
        master = UTIL.getMiniHBaseCluster().getMaster();
        rootDir = master.getMasterFileSystem().getRootDir();
        snapshots = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        archiveDir = new Path(rootDir, "archive");
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 3);
        conf.setInt("hbase.hstore.compactionThreshold", 5);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.set("hbase.master.hfilecleaner.plugins", "");
        conf.set("hbase.master.logcleaner.plugins", "");
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setLong("hbase.master.hfilecleaner.plugins.snapshot.period", 500L);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @Before
    public void setup() throws Exception {
        UTIL.createTable(TABLE_NAME, TEST_FAM);
        master.getSnapshotManagerForTesting().setSnapshotHandlerForTesting(TABLE_NAME, null);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testIsDoneContract() throws Exception {
        MasterProtos.IsSnapshotDoneRequest.Builder builder = MasterProtos.IsSnapshotDoneRequest.newBuilder();
        String snapshotName = "asyncExpectedFailureTest";
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(TABLE_NAME.getNameAsString()).build();
        builder.setSnapshot(desc);
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        DisabledTableSnapshotHandler mockHandler = (DisabledTableSnapshotHandler)Mockito.mock(DisabledTableSnapshotHandler.class);
        Mockito.when((Object)((Object)mockHandler.getException())).thenReturn(null);
        Mockito.when((Object)mockHandler.getSnapshot()).thenReturn((Object)desc);
        Mockito.when((Object)mockHandler.isFinished()).thenReturn((Object)new Boolean(true));
        Mockito.when((Object)mockHandler.getCompletionTimestamp()).thenReturn((Object)EnvironmentEdgeManager.currentTimeMillis());
        master.getSnapshotManagerForTesting().setSnapshotHandlerForTesting(TABLE_NAME, (SnapshotSentinel)mockHandler);
        builder = MasterProtos.IsSnapshotDoneRequest.newBuilder();
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        builder.setSnapshot(desc);
        MasterProtos.IsSnapshotDoneResponse response = master.isSnapshotDone(null, builder.build());
        Assert.assertTrue((String)"Snapshot didn't complete when it should have.", (boolean)response.getDone());
        builder.setSnapshot(HBaseProtos.SnapshotDescription.newBuilder().setName("Not A Snapshot").build());
        SnapshotTestingUtils.expectSnapshotDoneException(master, builder.build(), UnknownSnapshotException.class);
        snapshotName = "completed";
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        desc = desc.toBuilder().setName(snapshotName).build();
        SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)desc, (Path)snapshotDir, (FileSystem)fs);
        builder.setSnapshot(desc);
        response = master.isSnapshotDone(null, builder.build());
        Assert.assertTrue((String)"Completed, on-disk snapshot not found", (boolean)response.getDone());
    }

    @Test(timeout=300000L)
    public void testGetCompletedSnapshots() throws Exception {
        MasterProtos.GetCompletedSnapshotsRequest request = MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build();
        MasterProtos.GetCompletedSnapshotsResponse response = master.getCompletedSnapshots(null, request);
        Assert.assertEquals((String)"Found unexpected number of snapshots", (long)0L, (long)response.getSnapshotsCount());
        String snapshotName = "completed";
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build();
        SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)snapshot, (Path)snapshotDir, (FileSystem)fs);
        response = master.getCompletedSnapshots(null, request);
        Assert.assertEquals((String)"Found unexpected number of snapshots", (long)1L, (long)response.getSnapshotsCount());
        List snapshots = response.getSnapshotsList();
        ArrayList expected = Lists.newArrayList((Object[])new HBaseProtos.SnapshotDescription[]{snapshot});
        Assert.assertEquals((String)"Returned snapshots don't match created snapshots", (Object)expected, (Object)snapshots);
        snapshotName = "completed_two";
        snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build();
        SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)snapshot, (Path)snapshotDir, (FileSystem)fs);
        expected.add(snapshot);
        response = master.getCompletedSnapshots(null, request);
        Assert.assertEquals((String)"Found unexpected number of snapshots", (long)2L, (long)response.getSnapshotsCount());
        snapshots = response.getSnapshotsList();
        Assert.assertEquals((String)"Returned snapshots don't match created snapshots", (Object)expected, (Object)snapshots);
    }

    @Test(timeout=300000L)
    public void testDeleteSnapshot() throws Exception {
        String snapshotName = "completed";
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build();
        MasterProtos.DeleteSnapshotRequest request = MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        try {
            master.deleteSnapshot(null, request);
            Assert.fail((String)"Master didn't throw exception when attempting to delete snapshot that doesn't exist");
        }
        catch (ServiceException e) {
            LOG.debug((Object)("Correctly failed delete of non-existant snapshot:" + e.getMessage()));
        }
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)snapshot, (Path)snapshotDir, (FileSystem)fs);
        master.deleteSnapshot(null, request);
    }

    @Test(timeout=300000L)
    public void testSnapshotHFileArchiving() throws Exception {
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        UTIL.deleteTable(TABLE_NAME);
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        htd.setCompactionEnabled(false);
        UTIL.createTable(htd, (byte[][])new byte[][]{TEST_FAM}, UTIL.getConfiguration());
        UTIL.loadTable(new HTable(UTIL.getConfiguration(), TABLE_NAME), TEST_FAM);
        UTIL.flush(TABLE_NAME);
        UTIL.loadTable(new HTable(UTIL.getConfiguration(), TABLE_NAME), TEST_FAM);
        admin.disableTable(TABLE_NAME);
        htd.setCompactionEnabled(true);
        String snapshotName = "snapshot";
        byte[] snapshotNameBytes = Bytes.toBytes((String)snapshotName);
        admin.snapshot(snapshotNameBytes, TABLE_NAME);
        LOG.info((Object)"After snapshot File-System state");
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshotNameBytes, TABLE_NAME);
        admin.modifyTable(TABLE_NAME, htd);
        admin.enableTable(TABLE_NAME);
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(TABLE_NAME);
        for (HRegion region : regions) {
            region.waitForFlushesAndCompactions();
            region.compactStores();
        }
        LOG.info((Object)"After compaction File-System state");
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        LOG.debug((Object)"Running hfile cleaners");
        TestSnapshotFromMaster.ensureHFileCleanersRun();
        LOG.info((Object)("After cleaners File-System state: " + rootDir));
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Path snapshotTable = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        Set snapshotHFiles = SnapshotReferenceUtil.getHFileNames((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (Path)snapshotTable);
        LOG.debug((Object)"Have snapshot hfiles:");
        for (String fileName : snapshotHFiles) {
            LOG.debug((Object)fileName);
        }
        Collection<String> files = this.getArchivedHFiles(archiveDir, rootDir, fs, TABLE_NAME);
        for (String fileName : snapshotHFiles) {
            Assert.assertTrue((String)("Archived hfiles " + files + " is missing snapshot file:" + fileName), (boolean)files.contains(fileName));
        }
        admin.deleteSnapshot(snapshotNameBytes);
        SnapshotTestingUtils.assertNoSnapshots(admin);
        List delegates = TestSnapshotFromMaster.UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().cleanersChain;
        for (BaseHFileCleanerDelegate delegate : delegates) {
            if (!(delegate instanceof SnapshotHFileCleaner)) continue;
            ((SnapshotHFileCleaner)delegate).getFileCacheForTesting().triggerCacheRefreshForTesting();
        }
        LOG.debug((Object)"Running hfile cleaners");
        TestSnapshotFromMaster.ensureHFileCleanersRun();
        LOG.info((Object)"After delete snapshot cleaners run File-System state");
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        files = this.getArchivedHFiles(archiveDir, rootDir, fs, TABLE_NAME);
        Assert.assertEquals((String)"Still have some hfiles in the archive, when their snapshot has been deleted.", (long)0L, (long)files.size());
    }

    private final Collection<String> getArchivedHFiles(Path archiveDir, Path rootDir, FileSystem fs, TableName tableName) throws IOException {
        Path tableArchive = FSUtils.getTableDir((Path)archiveDir, (TableName)tableName);
        Path[] archivedHFiles = SnapshotTestingUtils.listHFiles(fs, tableArchive);
        ArrayList<String> files = new ArrayList<String>(archivedHFiles.length);
        LOG.debug((Object)("Have archived hfiles: " + tableArchive));
        for (Path file : archivedHFiles) {
            LOG.debug((Object)file);
            files.add(file.getName());
        }
        Collections.sort(files);
        return files;
    }

    private static void ensureHFileCleanersRun() {
        UTIL.getHBaseCluster().getMaster().getHFileCleaner().chore();
    }

    static {
        TEST_FAM = Bytes.toBytes((String)"fam");
        TABLE_NAME = TableName.valueOf((String)"test");
    }
}

