/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StripeStoreEngine;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.NoLimitCompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestStripeStoreEngine {
    @Test
    public void testCreateBasedOnConfig() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", TestStoreEngine.class.getName());
        TestStoreEngine se = TestStripeStoreEngine.createEngine(conf);
        Assert.assertTrue((boolean)(se.getCompactionPolicy() instanceof StripeCompactionPolicy));
    }

    @Test
    public void testCompactionContextForceSelect() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int targetCount = 2;
        conf.setInt("hbase.store.stripe.initialStripeCount", targetCount);
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 2);
        conf.set("hbase.hstore.engine.class", TestStoreEngine.class.getName());
        TestStoreEngine se = TestStripeStoreEngine.createEngine(conf);
        StripeCompactor mockCompactor = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        se.setCompactorOverride(mockCompactor);
        Mockito.when((Object)mockCompactor.compact((CompactionRequest)Matchers.any(CompactionRequest.class), Matchers.anyInt(), Matchers.anyLong(), (byte[])Matchers.any(byte[].class), (byte[])Matchers.any(byte[].class), (byte[])Matchers.any(byte[].class), (byte[])Matchers.any(byte[].class), (CompactionThroughputController)Matchers.any(CompactionThroughputController.class))).thenReturn(new ArrayList());
        StoreFile sf = TestStripeStoreEngine.createFile();
        ArrayList<StoreFile> compactUs = TestStripeStoreEngine.al(sf, TestStripeStoreEngine.createFile(), TestStripeStoreEngine.createFile());
        se.getStoreFileManager().loadFiles(compactUs);
        CompactionContext compaction = se.createCompaction();
        compaction.select(TestStripeStoreEngine.al(new StoreFile[0]), false, false, false);
        Assert.assertEquals((long)3L, (long)compaction.getRequest().getFiles().size());
        compactUs.remove(sf);
        CompactionRequest req = new CompactionRequest(compactUs);
        compaction.forceSelect(req);
        Assert.assertEquals((long)2L, (long)compaction.getRequest().getFiles().size());
        Assert.assertFalse((boolean)compaction.getRequest().getFiles().contains(sf));
        compaction.compact((CompactionThroughputController)NoLimitCompactionThroughputController.INSTANCE);
        ((StripeCompactor)Mockito.verify((Object)mockCompactor, (VerificationMode)Mockito.times((int)1))).compact(compaction.getRequest(), targetCount, 0L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, null, null, (CompactionThroughputController)NoLimitCompactionThroughputController.INSTANCE);
    }

    private static StoreFile createFile() throws Exception {
        StoreFile sf = (StoreFile)Mockito.mock(StoreFile.class);
        Mockito.when((Object)sf.getMetadataValue((byte[])Matchers.any(byte[].class))).thenReturn((Object)StripeStoreFileManager.INVALID_KEY);
        Mockito.when((Object)sf.getReader()).thenReturn(Mockito.mock(StoreFile.Reader.class));
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("moo"));
        return sf;
    }

    private static TestStoreEngine createEngine(Configuration conf) throws Exception {
        Store store = (Store)Mockito.mock(Store.class);
        KeyValue.KVComparator kvComparator = (KeyValue.KVComparator)Mockito.mock(KeyValue.KVComparator.class);
        return (TestStoreEngine)StoreEngine.create((Store)store, (Configuration)conf, (KeyValue.KVComparator)kvComparator);
    }

    private static ArrayList<StoreFile> al(StoreFile ... sfs) {
        return new ArrayList<StoreFile>(Arrays.asList(sfs));
    }

    public static class TestStoreEngine
    extends StripeStoreEngine {
        public void setCompactorOverride(StripeCompactor compactorOverride) {
            this.compactor = compactorOverride;
        }
    }
}

