/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.hfile.slab.Slab;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSlab {
    static final int BLOCKSIZE = 1000;
    static final int NUMBLOCKS = 100;
    Slab testSlab;
    ByteBuffer[] buffers = new ByteBuffer[100];

    @Before
    public void setUp() {
        this.testSlab = new Slab(1000, 100);
    }

    @After
    public void tearDown() {
        this.testSlab.shutdown();
    }

    @Test
    public void testBasicFunctionality() throws InterruptedException {
        int i;
        for (i = 0; i < 100; ++i) {
            this.buffers[i] = this.testSlab.alloc(1000);
            Assert.assertEquals((long)1000L, (long)this.buffers[i].limit());
        }
        for (i = 0; i < 100; ++i) {
            this.buffers[i].putInt(i);
        }
        for (i = 0; i < 100; ++i) {
            this.buffers[i].putInt(i);
        }
        for (i = 0; i < 100; ++i) {
            this.testSlab.free(this.buffers[i]);
        }
        for (i = 0; i < 100; ++i) {
            this.buffers[i] = this.testSlab.alloc(1000);
            Assert.assertEquals((long)1000L, (long)this.buffers[i].limit());
        }
    }
}

