/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV3;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class})
public class TestCacheOnWrite {
    private static final Log LOG = LogFactory.getLog(TestCacheOnWrite.class);
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private Configuration conf;
    private CacheConfig cacheConf;
    private FileSystem fs;
    private Random rand = new Random(12983177L);
    private Path storeFilePath;
    private BlockCache blockCache;
    private String testDescription;
    private final CacheOnWriteType cowType;
    private final Compression.Algorithm compress;
    private final BlockEncoderTestType encoderType;
    private final HFileDataBlockEncoder encoder;
    private final boolean cacheCompressedData;
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final int NUM_KV = 25000;
    private static final int INDEX_BLOCK_SIZE = 512;
    private static final int BLOOM_BLOCK_SIZE = 4096;
    private static final BloomType BLOOM_TYPE = BloomType.ROWCOL;
    private static final int CKBYTES = 512;
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final DataBlockEncoding ENCODING_ALGO = DataBlockEncoding.PREFIX;

    public TestCacheOnWrite(CacheOnWriteType cowType, Compression.Algorithm compress, BlockEncoderTestType encoderType, boolean cacheCompressedData, BlockCache blockCache) {
        this.cowType = cowType;
        this.compress = compress;
        this.encoderType = encoderType;
        this.encoder = encoderType.getEncoder();
        this.cacheCompressedData = cacheCompressedData;
        this.blockCache = blockCache;
        this.testDescription = "[cacheOnWrite=" + (Object)((Object)cowType) + ", compress=" + compress + ", encoderType=" + (Object)((Object)encoderType) + ", cacheCompressedData=" + cacheCompressedData + ", blockCache=" + blockCache.getClass().getSimpleName() + "]";
        LOG.info((Object)this.testDescription);
    }

    private static List<BlockCache> getBlockCaches() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        ArrayList<BlockCache> blockcaches = new ArrayList<BlockCache>();
        blockcaches.add(new CacheConfig(conf).getBlockCache());
        LruBlockCache lru = new LruBlockCache(0x8000000L, 65536L, TEST_UTIL.getConfiguration());
        blockcaches.add((BlockCache)lru);
        FileSystem.get((Configuration)conf).mkdirs(TEST_UTIL.getDataTestDir());
        int[] bucketSizes = new int[]{512, 2048, 4096, 65536, 131072};
        BucketCache bucketcache = new BucketCache("offheap", 0x8000000L, 65536, bucketSizes, 5, 6400, null);
        blockcaches.add((BlockCache)bucketcache);
        return blockcaches;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() throws IOException {
        ArrayList<Object[]> cowTypes = new ArrayList<Object[]>();
        for (BlockCache blockache : TestCacheOnWrite.getBlockCaches()) {
            for (CacheOnWriteType cowType : CacheOnWriteType.values()) {
                for (Compression.Algorithm compress : HBaseTestingUtility.COMPRESSION_ALGORITHMS) {
                    for (BlockEncoderTestType encoderType : BlockEncoderTestType.values()) {
                        for (boolean cacheCompressedData : new boolean[]{false, true}) {
                            cowTypes.add(new Object[]{cowType, compress, encoderType, cacheCompressedData, blockache});
                        }
                    }
                }
            }
        }
        return cowTypes;
    }

    private void clearBlockCache(BlockCache blockCache) throws InterruptedException {
        if (blockCache instanceof LruBlockCache) {
            ((LruBlockCache)blockCache).clearCache();
        } else {
            int clearCount = 0;
            while (blockCache.getBlockCount() > 0L) {
                if (clearCount > 0) {
                    LOG.warn((Object)("clear block cache " + blockCache + " " + clearCount + " times, " + blockCache.getBlockCount() + " blocks remaining"));
                    Thread.sleep(10L);
                }
                for (CachedBlock block : Lists.newArrayList((Iterable)blockCache)) {
                    blockCache.evictBlocksByHfileName(block.getFilename());
                }
                ++clearCount;
            }
        }
    }

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.set("dfs.datanode.data.dir.perm", "700");
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setInt("hfile.index.block.max.size", 512);
        this.conf.setInt("io.storefile.bloom.block.size", 4096);
        this.conf.setBoolean("hbase.block.data.cachecompressed", this.cacheCompressedData);
        this.cowType.modifyConf(this.conf);
        this.fs = HFileSystem.get((Configuration)this.conf);
        CacheConfig.GLOBAL_BLOCK_CACHE_INSTANCE = this.blockCache;
        this.cacheConf = new CacheConfig(this.blockCache, true, true, this.cowType.shouldBeCached(BlockType.DATA), this.cowType.shouldBeCached(BlockType.LEAF_INDEX), this.cowType.shouldBeCached(BlockType.BLOOM_CHUNK), false, this.cacheCompressedData, false);
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.clearBlockCache(this.blockCache);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
    }

    private void testStoreFileCacheOnWriteInternals(boolean useTags) throws IOException {
        this.writeStoreFile(useTags);
        this.readStoreFile(useTags);
    }

    private void readStoreFile(boolean useTags) throws IOException {
        BlockType cachedDataBlockType;
        HFileBlock block;
        Object reader = useTags ? (HFileReaderV3)HFile.createReader((FileSystem)this.fs, (Path)this.storeFilePath, (CacheConfig)this.cacheConf, (Configuration)this.conf) : (HFileReaderV2)HFile.createReader((FileSystem)this.fs, (Path)this.storeFilePath, (CacheConfig)this.cacheConf, (Configuration)this.conf);
        LOG.info((Object)("HFile information: " + reader));
        HFileContext meta = new HFileContextBuilder().withCompression(this.compress).withBytesPerCheckSum(512).withChecksumType(ChecksumType.NULL).withBlockSize(2048).withDataBlockEncoding(this.encoder.getDataBlockEncoding()).withIncludesTags(useTags).build();
        boolean cacheBlocks = false;
        boolean pread = false;
        HFileScanner scanner = reader.getScanner(false, false);
        Assert.assertTrue((String)this.testDescription, (boolean)scanner.seekTo());
        HFileBlock prevBlock = null;
        EnumMap<BlockType, Integer> blockCountByType = new EnumMap<BlockType, Integer>(BlockType.class);
        DataBlockEncoding encodingInCache = this.encoderType.getEncoder().getDataBlockEncoding();
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            BlockType bt;
            long onDiskSize = -1L;
            if (prevBlock != null) {
                onDiskSize = prevBlock.getNextBlockOnDiskSizeWithHeader();
            }
            block = reader.readBlock(offset, onDiskSize, false, true, false, true, null);
            BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset, encodingInCache, block.getBlockType());
            HFileBlock fromCache = (HFileBlock)this.blockCache.getBlock(blockCacheKey, true, false, true);
            boolean isCached = fromCache != null;
            boolean shouldBeCached = this.cowType.shouldBeCached(block.getBlockType());
            Assert.assertTrue((String)("shouldBeCached: " + shouldBeCached + "\n" + "isCached: " + isCached + "\n" + "Test description: " + this.testDescription + "\n" + "block: " + block + "\n" + "encodingInCache: " + encodingInCache + "\n" + "blockCacheKey: " + blockCacheKey), (shouldBeCached == isCached ? 1 : 0) != 0);
            if (isCached) {
                if (this.cacheConf.shouldCacheCompressed(fromCache.getBlockType().getCategory())) {
                    if (this.compress != Compression.Algorithm.NONE) {
                        Assert.assertFalse((boolean)fromCache.isUnpacked());
                    }
                    fromCache = fromCache.unpack(meta, reader.getUncachedBlockReader());
                } else {
                    Assert.assertTrue((boolean)fromCache.isUnpacked());
                }
                Assert.assertEquals((long)block.getChecksumType(), (long)fromCache.getChecksumType());
                Assert.assertEquals((Object)block.getBlockType(), (Object)fromCache.getBlockType());
                if (block.getBlockType() == BlockType.ENCODED_DATA) {
                    Assert.assertEquals((long)block.getDataBlockEncodingId(), (long)fromCache.getDataBlockEncodingId());
                    Assert.assertEquals((Object)block.getDataBlockEncoding(), (Object)fromCache.getDataBlockEncoding());
                }
                Assert.assertEquals((long)block.getOnDiskSizeWithHeader(), (long)fromCache.getOnDiskSizeWithHeader());
                Assert.assertEquals((long)block.getOnDiskSizeWithoutHeader(), (long)fromCache.getOnDiskSizeWithoutHeader());
                Assert.assertEquals((long)block.getUncompressedSizeWithoutHeader(), (long)fromCache.getUncompressedSizeWithoutHeader());
            }
            prevBlock = block;
            Integer count = (Integer)blockCountByType.get(bt = block.getBlockType());
            blockCountByType.put(bt, (count == null ? 0 : count) + 1);
        }
        LOG.info((Object)("Block count by type: " + blockCountByType));
        String countByType = blockCountByType.toString();
        BlockType blockType = cachedDataBlockType = this.encoderType.encode ? BlockType.ENCODED_DATA : BlockType.DATA;
        if (useTags) {
            Assert.assertEquals((Object)("{" + cachedDataBlockType + "=2663, LEAF_INDEX=297, BLOOM_CHUNK=9, INTERMEDIATE_INDEX=34}"), (Object)countByType);
        } else {
            Assert.assertEquals((Object)("{" + cachedDataBlockType + "=2498, LEAF_INDEX=278, BLOOM_CHUNK=9, INTERMEDIATE_INDEX=31}"), (Object)countByType);
        }
        while (scanner.next()) {
            scanner.getKeyValue();
        }
        reader.close();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". " + "Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private void writeStoreFile(boolean useTags) throws IOException {
        if (useTags) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        } else {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 2);
        }
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), "test_cache_on_write");
        HFileContext meta = new HFileContextBuilder().withCompression(this.compress).withBytesPerCheckSum(512).withChecksumType(ChecksumType.NULL).withBlockSize(2048).withDataBlockEncoding(this.encoder.getDataBlockEncoding()).withIncludesTags(useTags).build();
        StoreFile.Writer sfw = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withOutputDir(storeFileParentDir).withComparator(KeyValue.COMPARATOR).withFileContext(meta).withBloomType(BLOOM_TYPE).withMaxKeyCount(25000L).build();
        byte[] cf = Bytes.toBytes((String)"fam");
        for (int i = 0; i < 25000; ++i) {
            KeyValue kv;
            byte[] row = TestHFileWriterV2.randomOrderedKey(this.rand, i);
            byte[] qualifier = TestHFileWriterV2.randomRowOrQualifier(this.rand);
            byte[] value = TestHFileWriterV2.randomValue(this.rand);
            if (useTags) {
                Tag t = new Tag(1, "visibility");
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                tagList.add(t);
                Tag[] tags = new Tag[]{t};
                kv = new KeyValue(row, 0, row.length, cf, 0, cf.length, qualifier, 0, qualifier.length, this.rand.nextLong(), TestCacheOnWrite.generateKeyType(this.rand), value, 0, value.length, tagList);
            } else {
                kv = new KeyValue(row, 0, row.length, cf, 0, cf.length, qualifier, 0, qualifier.length, this.rand.nextLong(), TestCacheOnWrite.generateKeyType(this.rand), value, 0, value.length);
            }
            sfw.append(kv);
        }
        sfw.close();
        this.storeFilePath = sfw.getPath();
    }

    private void testNotCachingDataBlocksDuringCompactionInternals(boolean useTags) throws IOException, InterruptedException {
        if (useTags) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        } else {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 2);
        }
        String table = "CompactionCacheOnWrite";
        String cf = "myCF";
        byte[] cfBytes = Bytes.toBytes((String)"myCF");
        int maxVersions = 3;
        HRegion region = TEST_UTIL.createTestRegion("CompactionCacheOnWrite", new HColumnDescriptor("myCF").setCompressionType(this.compress).setBloomFilterType(BLOOM_TYPE).setMaxVersions(3).setDataBlockEncoding(this.encoder.getDataBlockEncoding()));
        int rowIdx = 0;
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        for (int iFile = 0; iFile < 5; ++iFile) {
            for (int iRow = 0; iRow < 500; ++iRow) {
                String rowStr = "" + rowIdx * rowIdx * rowIdx + "row" + iFile + "_" + iRow;
                Put p = new Put(Bytes.toBytes((String)rowStr));
                ++rowIdx;
                for (int iCol = 0; iCol < 10; ++iCol) {
                    String qualStr = "col" + iCol;
                    String valueStr = "value_" + rowStr + "_" + qualStr;
                    for (int iTS = 0; iTS < 5; ++iTS) {
                        if (useTags) {
                            Tag t = new Tag(1, "visibility");
                            Tag[] tags = new Tag[]{t};
                            KeyValue kv = new KeyValue(Bytes.toBytes((String)rowStr), cfBytes, Bytes.toBytes((String)qualStr), Long.MAX_VALUE, Bytes.toBytes((String)valueStr), tags);
                            p.add((Cell)kv);
                            continue;
                        }
                        p.add(cfBytes, Bytes.toBytes((String)qualStr), ts++, Bytes.toBytes((String)valueStr));
                    }
                }
                p.setDurability(Durability.ASYNC_WAL);
                region.put(p);
            }
            region.flushcache();
        }
        this.clearBlockCache(this.blockCache);
        Assert.assertEquals((long)0L, (long)this.blockCache.getBlockCount());
        region.compactStores();
        LOG.debug((Object)"compactStores() returned");
        for (CachedBlock block : this.blockCache) {
            Assert.assertNotEquals((Object)BlockType.ENCODED_DATA, (Object)block.getBlockType());
            Assert.assertNotEquals((Object)BlockType.DATA, (Object)block.getBlockType());
        }
        region.close();
    }

    @Test
    public void testStoreFileCacheOnWrite() throws IOException {
        this.testStoreFileCacheOnWriteInternals(false);
        this.testStoreFileCacheOnWriteInternals(true);
    }

    @Test
    public void testNotCachingDataBlocksDuringCompaction() throws IOException, InterruptedException {
        this.testNotCachingDataBlocksDuringCompactionInternals(false);
        this.testNotCachingDataBlocksDuringCompactionInternals(true);
    }

    private static enum BlockEncoderTestType {
        NO_BLOCK_ENCODING_NOOP(true, false),
        NO_BLOCK_ENCODING(false, false),
        BLOCK_ENCODING_EVERYWHERE(false, true);

        private final boolean noop;
        private final boolean encode;

        private BlockEncoderTestType(boolean noop, boolean encode) {
            this.encode = encode;
            this.noop = noop;
        }

        public HFileDataBlockEncoder getEncoder() {
            return this.noop ? NoOpDataBlockEncoder.INSTANCE : new HFileDataBlockEncoderImpl(this.encode ? ENCODING_ALGO : DataBlockEncoding.NONE);
        }
    }

    private static enum CacheOnWriteType {
        DATA_BLOCKS("hbase.rs.cacheblocksonwrite", BlockType.DATA, BlockType.ENCODED_DATA),
        BLOOM_BLOCKS("hfile.block.bloom.cacheonwrite", BlockType.BLOOM_CHUNK),
        INDEX_BLOCKS("hfile.block.index.cacheonwrite", BlockType.LEAF_INDEX, BlockType.INTERMEDIATE_INDEX);

        private final String confKey;
        private final BlockType blockType1;
        private final BlockType blockType2;

        private CacheOnWriteType(String confKey, BlockType blockType) {
            this(confKey, blockType, blockType);
        }

        private CacheOnWriteType(String confKey, BlockType blockType1, BlockType blockType2) {
            this.blockType1 = blockType1;
            this.blockType2 = blockType2;
            this.confKey = confKey;
        }

        public boolean shouldBeCached(BlockType blockType) {
            return blockType == this.blockType1 || blockType == this.blockType2;
        }

        public void modifyConf(Configuration conf) {
            for (CacheOnWriteType cowType : CacheOnWriteType.values()) {
                conf.setBoolean(cowType.confKey, cowType == this);
            }
        }
    }
}

