/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.BigDecimalColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestBigDecimalColumnInterpreter {
    protected static Log myLog = LogFactory.getLog(TestBigDecimalColumnInterpreter.class);
    private static final TableName TEST_TABLE = TableName.valueOf((String)"TestTable");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"TestFamily");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"TestQualifier");
    private static final byte[] TEST_MULTI_CQ = Bytes.toBytes((String)"TestMultiCQ");
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int ROWSIZE = 20;
    private static final int rowSeperator1 = 5;
    private static final int rowSeperator2 = 12;
    private static byte[][] ROWS = TestBigDecimalColumnInterpreter.makeN(ROW, 20);
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static Configuration conf = util.getConfiguration();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.set("hbase.coprocessor.region.classes", "org.apache.hadoop.hbase.coprocessor.AggregateImplementation");
        util.startMiniCluster(2);
        HTable table = util.createTable(TEST_TABLE, TEST_FAMILY);
        util.createMultiRegions(util.getConfiguration(), table, TEST_FAMILY, new byte[][]{HConstants.EMPTY_BYTE_ARRAY, ROWS[5], ROWS[12]});
        for (int i = 0; i < 20; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            BigDecimal bd = new BigDecimal(i);
            put.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((BigDecimal)bd));
            table.put(put);
            Put p2 = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            p2.add(TEST_FAMILY, Bytes.add((byte[])TEST_MULTI_CQ, (byte[])Bytes.toBytes((BigDecimal)bd)), Bytes.toBytes((BigDecimal)bd.multiply(new BigDecimal("0.10"))));
            table.put(p2);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((int)i));
        }
        return ret;
    }

    @Test(timeout=300000L)
    public void testMedianWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal median = (BigDecimal)aClient.median(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("8.00"), (Object)median);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal maximum = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("19.00"), (Object)maximum);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal max = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("14.00"), (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal maximum = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("19.00"), (Object)maximum);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal max = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("6.00"), (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Scan scan = new Scan();
        BigDecimal max = null;
        try {
            max = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            max = null;
        }
        Assert.assertEquals(null, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Scan scan = new Scan();
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[2]);
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        BigDecimal max = new BigDecimal(Long.MIN_VALUE);
        try {
            max = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            max = BigDecimal.ZERO;
        }
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithInvalidRange2() throws Throwable {
        BigDecimal max = new BigDecimal(Long.MIN_VALUE);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[4]);
        try {
            AggregationClient aClient = new AggregationClient(conf);
            BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
            max = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Exception e) {
            max = BigDecimal.ZERO;
        }
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMaxWithFilter() throws Throwable {
        BigDecimal max = BigDecimal.ZERO;
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        scan.setFilter((Filter)f);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        max = (BigDecimal)aClient.max(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals(null, (Object)max);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(HConstants.EMPTY_START_ROW);
        scan.setStopRow(HConstants.EMPTY_END_ROW);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("0.00"), (Object)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("5.00"), (Object)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(HConstants.EMPTY_START_ROW);
        scan.setStopRow(HConstants.EMPTY_END_ROW);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("0.00"), (Object)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("0.60"), (Object)min);
    }

    @Test(timeout=300000L)
    public void testMinWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = null;
        try {
            min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        BigDecimal min = null;
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[4]);
        scan.setStopRow(ROWS[2]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        try {
            min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithInvalidRange2() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[6]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = null;
        try {
            min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, min);
    }

    @Test(timeout=300000L)
    public void testMinWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        scan.setFilter((Filter)f);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal min = null;
        min = (BigDecimal)aClient.min(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals(null, (Object)min);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("190.00"), (Object)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("95.00"), (Object)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("209.00"), (Object)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((Object)new BigDecimal("6.60"), (Object)sum);
    }

    @Test(timeout=300000L)
    public void testSumWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = null;
        try {
            sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, sum);
    }

    @Test(timeout=300000L)
    public void testSumWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[2]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = null;
        try {
            sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, sum);
    }

    @Test(timeout=300000L)
    public void testSumWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setFilter((Filter)f);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        BigDecimal sum = null;
        sum = (BigDecimal)aClient.sum(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals(null, (Object)sum);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)9.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)9.5, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)10.45, (double)avg, (double)0.01);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)6.6, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testAvgWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Double avg = null;
        try {
            avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, avg);
    }

    @Test(timeout=300000L)
    public void testAvgWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[1]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Double avg = null;
        try {
            avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, avg);
    }

    @Test(timeout=300000L)
    public void testAvgWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        scan.setFilter((Filter)f);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Double avg = null;
        avg = aClient.avg(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)Double.NaN, (double)avg, (double)0.0);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)5.766, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange2() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addColumn(TEST_FAMILY, TEST_QUALIFIER);
        scan.setStartRow(ROWS[5]);
        scan.setStopRow(ROWS[15]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)2.87, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRangeWithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)6.342, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRange2WithNoCQ() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[7]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        double std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        System.out.println("std is:" + std);
        Assert.assertEquals((double)0.0, (double)std, (double)0.05);
    }

    @Test(timeout=300000L)
    public void testStdWithValidRangeWithNullCF() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[17]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Double std = null;
        try {
            std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, std);
    }

    @Test
    public void testStdWithInvalidRange() {
        AggregationClient aClient = new AggregationClient(conf);
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setStartRow(ROWS[6]);
        scan.setStopRow(ROWS[1]);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Double std = null;
        try {
            std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Assert.assertEquals(null, std);
    }

    @Test(timeout=300000L)
    public void testStdWithFilter() throws Throwable {
        AggregationClient aClient = new AggregationClient(conf);
        PrefixFilter f = new PrefixFilter(Bytes.toBytes((String)"foo:bar"));
        Scan scan = new Scan();
        scan.addFamily(TEST_FAMILY);
        scan.setFilter((Filter)f);
        BigDecimalColumnInterpreter ci = new BigDecimalColumnInterpreter();
        Double std = null;
        std = aClient.std(TEST_TABLE, (ColumnInterpreter)ci, scan);
        Assert.assertEquals((double)Double.NaN, (double)std, (double)0.0);
    }
}

