/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.security.access.HbaseObjectWritableFor96Migration;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestHbaseObjectWritableFor96Migration {
    @Test
    public void testCustomWritable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CustomWritable custom = new CustomWritable("test phrase");
        Object obj = this.doType(conf, custom, CustomWritable.class);
        Assert.assertTrue((boolean)(obj instanceof Writable));
        Assert.assertTrue((boolean)(obj instanceof CustomWritable));
        Assert.assertEquals((Object)"test phrase", (Object)((CustomWritable)obj).getValue());
    }

    @Test
    public void testCustomSerializable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Configuration legacyConf = HBaseConfiguration.create();
        legacyConf.setBoolean("hbase.allow.legacy.object.serialization", true);
        CustomSerializable custom = new CustomSerializable("test phrase");
        try {
            this.writeType(conf, custom, CustomSerializable.class);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] data = this.writeType(legacyConf, custom, CustomSerializable.class);
        try {
            this.readType(conf, data);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Test
    public void testLegacyCustomSerializable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.allow.legacy.object.serialization", true);
        CustomSerializable custom = new CustomSerializable("test phrase");
        byte[] data = this.writeType(conf, custom, CustomSerializable.class);
        Object obj = this.readType(conf, data);
        Assert.assertTrue((boolean)(obj instanceof Serializable));
        Assert.assertTrue((boolean)(obj instanceof CustomSerializable));
        Assert.assertEquals((Object)"test phrase", (Object)((CustomSerializable)obj).getValue());
    }

    private Object doType(Configuration conf, Object value, Class<?> clazz) throws IOException {
        return this.readType(conf, this.writeType(conf, value, clazz));
    }

    private byte[] writeType(Configuration conf, Object value, Class<?> clazz) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        HbaseObjectWritableFor96Migration.writeObject((DataOutput)out, (Object)value, clazz, (Configuration)conf);
        out.close();
        return byteStream.toByteArray();
    }

    private Object readType(Configuration conf, byte[] value) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value));
        Object product = HbaseObjectWritableFor96Migration.readObject((DataInput)dis, (Configuration)conf);
        dis.close();
        return product;
    }

    @Test
    public void testGetClassCode() throws IOException {
        Assert.assertEquals((long)1L, (long)HbaseObjectWritableFor96Migration.getClassCode(Boolean.TYPE).intValue());
        Assert.assertEquals((long)2L, (long)HbaseObjectWritableFor96Migration.getClassCode(Byte.TYPE).intValue());
        Assert.assertEquals((long)3L, (long)HbaseObjectWritableFor96Migration.getClassCode(Character.TYPE).intValue());
        Assert.assertEquals((long)4L, (long)HbaseObjectWritableFor96Migration.getClassCode(Short.TYPE).intValue());
        Assert.assertEquals((long)5L, (long)HbaseObjectWritableFor96Migration.getClassCode(Integer.TYPE).intValue());
        Assert.assertEquals((long)6L, (long)HbaseObjectWritableFor96Migration.getClassCode(Long.TYPE).intValue());
        Assert.assertEquals((long)7L, (long)HbaseObjectWritableFor96Migration.getClassCode(Float.TYPE).intValue());
        Assert.assertEquals((long)8L, (long)HbaseObjectWritableFor96Migration.getClassCode(Double.TYPE).intValue());
        Assert.assertEquals((long)9L, (long)HbaseObjectWritableFor96Migration.getClassCode(Void.TYPE).intValue());
        Assert.assertEquals((long)10L, (long)HbaseObjectWritableFor96Migration.getClassCode(String.class).intValue());
        Assert.assertEquals((long)11L, (long)HbaseObjectWritableFor96Migration.getClassCode(byte[].class).intValue());
        Assert.assertEquals((long)12L, (long)HbaseObjectWritableFor96Migration.getClassCode(byte[][].class).intValue());
        Assert.assertEquals((long)13L, (long)HbaseObjectWritableFor96Migration.getClassCode(Text.class).intValue());
        Assert.assertEquals((long)14L, (long)HbaseObjectWritableFor96Migration.getClassCode(Writable.class).intValue());
        Assert.assertEquals((long)15L, (long)HbaseObjectWritableFor96Migration.getClassCode(Writable[].class).intValue());
        Assert.assertEquals((long)18L, (long)HbaseObjectWritableFor96Migration.getClassCode(HColumnDescriptor.class).intValue());
        Assert.assertEquals((long)19L, (long)HbaseObjectWritableFor96Migration.getClassCode(HConstants.Modify.class).intValue());
        Assert.assertEquals((long)24L, (long)HbaseObjectWritableFor96Migration.getClassCode(HRegionInfo.class).intValue());
        Assert.assertEquals((long)25L, (long)HbaseObjectWritableFor96Migration.getClassCode(HRegionInfo[].class).intValue());
        Assert.assertEquals((long)28L, (long)HbaseObjectWritableFor96Migration.getClassCode(HTableDescriptor.class).intValue());
        Assert.assertEquals((long)29L, (long)HbaseObjectWritableFor96Migration.getClassCode(MapWritable.class).intValue());
        Assert.assertEquals((long)30L, (long)HbaseObjectWritableFor96Migration.getClassCode(ClusterStatus.class).intValue());
        Assert.assertEquals((long)31L, (long)HbaseObjectWritableFor96Migration.getClassCode(Delete.class).intValue());
        Assert.assertEquals((long)32L, (long)HbaseObjectWritableFor96Migration.getClassCode(Get.class).intValue());
        Assert.assertEquals((long)33L, (long)HbaseObjectWritableFor96Migration.getClassCode(KeyValue.class).intValue());
        Assert.assertEquals((long)34L, (long)HbaseObjectWritableFor96Migration.getClassCode(KeyValue[].class).intValue());
        Assert.assertEquals((long)35L, (long)HbaseObjectWritableFor96Migration.getClassCode(Put.class).intValue());
        Assert.assertEquals((long)36L, (long)HbaseObjectWritableFor96Migration.getClassCode(Put[].class).intValue());
        Assert.assertEquals((long)37L, (long)HbaseObjectWritableFor96Migration.getClassCode(Result.class).intValue());
        Assert.assertEquals((long)38L, (long)HbaseObjectWritableFor96Migration.getClassCode(Result[].class).intValue());
        Assert.assertEquals((long)39L, (long)HbaseObjectWritableFor96Migration.getClassCode(Scan.class).intValue());
        Assert.assertEquals((long)40L, (long)HbaseObjectWritableFor96Migration.getClassCode(WhileMatchFilter.class).intValue());
        Assert.assertEquals((long)41L, (long)HbaseObjectWritableFor96Migration.getClassCode(PrefixFilter.class).intValue());
        Assert.assertEquals((long)42L, (long)HbaseObjectWritableFor96Migration.getClassCode(PageFilter.class).intValue());
        Assert.assertEquals((long)43L, (long)HbaseObjectWritableFor96Migration.getClassCode(InclusiveStopFilter.class).intValue());
        Assert.assertEquals((long)44L, (long)HbaseObjectWritableFor96Migration.getClassCode(ColumnCountGetFilter.class).intValue());
        Assert.assertEquals((long)45L, (long)HbaseObjectWritableFor96Migration.getClassCode(SingleColumnValueFilter.class).intValue());
        Assert.assertEquals((long)46L, (long)HbaseObjectWritableFor96Migration.getClassCode(SingleColumnValueExcludeFilter.class).intValue());
        Assert.assertEquals((long)47L, (long)HbaseObjectWritableFor96Migration.getClassCode(BinaryComparator.class).intValue());
        Assert.assertEquals((long)48L, (long)HbaseObjectWritableFor96Migration.getClassCode(BitComparator.class).intValue());
        Assert.assertEquals((long)49L, (long)HbaseObjectWritableFor96Migration.getClassCode(CompareFilter.class).intValue());
        Assert.assertEquals((long)50L, (long)HbaseObjectWritableFor96Migration.getClassCode(RowFilter.class).intValue());
        Assert.assertEquals((long)51L, (long)HbaseObjectWritableFor96Migration.getClassCode(ValueFilter.class).intValue());
        Assert.assertEquals((long)52L, (long)HbaseObjectWritableFor96Migration.getClassCode(QualifierFilter.class).intValue());
        Assert.assertEquals((long)53L, (long)HbaseObjectWritableFor96Migration.getClassCode(SkipFilter.class).intValue());
        Assert.assertEquals((long)55L, (long)HbaseObjectWritableFor96Migration.getClassCode(FirstKeyOnlyFilter.class).intValue());
        Assert.assertEquals((long)56L, (long)HbaseObjectWritableFor96Migration.getClassCode(DependentColumnFilter.class).intValue());
        Assert.assertEquals((long)57L, (long)HbaseObjectWritableFor96Migration.getClassCode(Delete[].class).intValue());
        Assert.assertEquals((long)58L, (long)HbaseObjectWritableFor96Migration.getClassCode(HLog.Entry.class).intValue());
        Assert.assertEquals((long)59L, (long)HbaseObjectWritableFor96Migration.getClassCode(HLog.Entry[].class).intValue());
        Assert.assertEquals((long)60L, (long)HbaseObjectWritableFor96Migration.getClassCode(HLogKey.class).intValue());
        Assert.assertEquals((long)61L, (long)HbaseObjectWritableFor96Migration.getClassCode(List.class).intValue());
        Assert.assertEquals((long)62L, (long)HbaseObjectWritableFor96Migration.getClassCode(NavigableSet.class).intValue());
        Assert.assertEquals((long)63L, (long)HbaseObjectWritableFor96Migration.getClassCode(ColumnPrefixFilter.class).intValue());
        Assert.assertEquals((long)64L, (long)HbaseObjectWritableFor96Migration.getClassCode(Row.class).intValue());
        Assert.assertEquals((long)65L, (long)HbaseObjectWritableFor96Migration.getClassCode(Action.class).intValue());
        Assert.assertEquals((long)66L, (long)HbaseObjectWritableFor96Migration.getClassCode(MultiAction.class).intValue());
        Assert.assertEquals((long)67L, (long)HbaseObjectWritableFor96Migration.getClassCode(MultiResponse.class).intValue());
        Assert.assertEquals((long)69L, (long)HbaseObjectWritableFor96Migration.getClassCode(Increment.class).intValue());
        Assert.assertEquals((long)70L, (long)HbaseObjectWritableFor96Migration.getClassCode(KeyOnlyFilter.class).intValue());
        Assert.assertEquals((long)71L, (long)HbaseObjectWritableFor96Migration.getClassCode(Serializable.class).intValue());
        Assert.assertEquals((long)72L, (long)HbaseObjectWritableFor96Migration.getClassCode(RandomRowFilter.class).intValue());
        Assert.assertEquals((long)73L, (long)HbaseObjectWritableFor96Migration.getClassCode(CompareFilter.CompareOp.class).intValue());
        Assert.assertEquals((long)74L, (long)HbaseObjectWritableFor96Migration.getClassCode(ColumnRangeFilter.class).intValue());
        Assert.assertEquals((long)76L, (long)HbaseObjectWritableFor96Migration.getClassCode(RegionOpeningState.class).intValue());
        Assert.assertEquals((long)77L, (long)HbaseObjectWritableFor96Migration.getClassCode(HTableDescriptor[].class).intValue());
        Assert.assertEquals((long)78L, (long)HbaseObjectWritableFor96Migration.getClassCode(Append.class).intValue());
        Assert.assertEquals((long)79L, (long)HbaseObjectWritableFor96Migration.getClassCode(RowMutations.class).intValue());
        Assert.assertEquals((long)80L, (long)HbaseObjectWritableFor96Migration.getClassCode(Message.class).intValue());
        Assert.assertEquals((long)81L, (long)HbaseObjectWritableFor96Migration.getClassCode(Array.class).intValue());
    }

    public void testGetNextObjectCode() {
        Assert.assertEquals((long)83L, (long)HbaseObjectWritableFor96Migration.getNextClassCode());
    }

    public static class CustomWritable
    implements Writable {
        private String value = null;

        public CustomWritable() {
        }

        public CustomWritable(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.value);
        }

        public void readFields(DataInput in) throws IOException {
            this.value = Text.readString((DataInput)in);
        }
    }

    public static class CustomSerializable
    implements Serializable {
        private static final long serialVersionUID = 1048445561865740632L;
        private String value = null;

        public CustomSerializable() {
        }

        public CustomSerializable(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

