/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mapreduce.HLogInputFormat;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHLogRecordReader {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static FileSystem fs;
    private static Path hbaseDir;
    private static final TableName tableName;
    private static final byte[] rowName;
    private static final HRegionInfo info;
    private static final byte[] family;
    private static final byte[] value;
    private static HTableDescriptor htd;
    private static Path logDir;
    private static String logName;

    private static String getName() {
        return "TestHLogRecordReader";
    }

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(hbaseDir)) {
            fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.replication", 1);
        TEST_UTIL.startMiniDFSCluster(1);
        conf = TEST_UTIL.getConfiguration();
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        hbaseDir = TEST_UTIL.createRootDir();
        logName = "WALs";
        logDir = new Path(hbaseDir, logName);
        htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPartialRead() throws Exception {
        HLog log = HLogFactory.createHLog((FileSystem)fs, (Path)hbaseDir, (String)logName, (Configuration)conf);
        long ts = System.currentTimeMillis();
        WALEdit edit = new WALEdit();
        AtomicLong sequenceId = new AtomicLong(0L);
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"1"), ts, value));
        log.append(info, tableName, edit, ts, htd, sequenceId);
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"2"), ts + 1L, value));
        log.append(info, tableName, edit, ts + 1L, htd, sequenceId);
        log.rollWriter();
        Thread.sleep(1L);
        long ts1 = System.currentTimeMillis();
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"3"), ts1 + 1L, value));
        log.append(info, tableName, edit, ts1 + 1L, htd, sequenceId);
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"4"), ts1 + 2L, value));
        log.append(info, tableName, edit, ts1 + 2L, htd, sequenceId);
        log.close();
        HLogInputFormat input = new HLogInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapred.input.dir", logDir.toString());
        jobConf.setLong("hlog.end.time", ts);
        List splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        jobConf.setLong("hlog.start.time", ts + 1L);
        jobConf.setLong("hlog.end.time", ts1 + 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"2")});
        this.testSplit((InputSplit)splits.get(1), new byte[][]{Bytes.toBytes((String)"3")});
    }

    @Test
    public void testHLogRecordReader() throws Exception {
        HLog log = HLogFactory.createHLog((FileSystem)fs, (Path)hbaseDir, (String)logName, (Configuration)conf);
        byte[] value = Bytes.toBytes((String)"value");
        AtomicLong sequenceId = new AtomicLong(0L);
        WALEdit edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"1"), System.currentTimeMillis(), value));
        log.append(info, tableName, edit, System.currentTimeMillis(), htd, sequenceId);
        Thread.sleep(1L);
        long secondTs = System.currentTimeMillis();
        log.rollWriter();
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes((String)"2"), System.currentTimeMillis(), value));
        log.append(info, tableName, edit, System.currentTimeMillis(), htd, sequenceId);
        log.close();
        long thirdTs = System.currentTimeMillis();
        HLogInputFormat input = new HLogInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapred.input.dir", logDir.toString());
        List splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        this.testSplit((InputSplit)splits.get(1), new byte[][]{Bytes.toBytes((String)"2")});
        jobConf.setLong("hlog.end.time", secondTs - 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[][]{Bytes.toBytes((String)"1")});
        jobConf.setLong("hlog.end.time", Long.MAX_VALUE);
        jobConf.setLong("hlog.start.time", thirdTs);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit((InputSplit)splits.get(0), new byte[0][]);
        this.testSplit((InputSplit)splits.get(1), new byte[0][]);
    }

    private void testSplit(InputSplit split, byte[] ... columns) throws Exception {
        HLogInputFormat.HLogRecordReader reader = new HLogInputFormat.HLogRecordReader();
        reader.initialize(split, MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)conf));
        for (byte[] column : columns) {
            Assert.assertTrue((boolean)reader.nextKeyValue());
            KeyValue kv = (KeyValue)reader.getCurrentValue().getKeyValues().get(0);
            if (Bytes.equals((byte[])column, (byte[])kv.getQualifier())) continue;
            Assert.assertTrue((String)("expected [" + Bytes.toString((byte[])column) + "], actual [" + Bytes.toString((byte[])kv.getQualifier()) + "]"), (boolean)false);
        }
        Assert.assertFalse((boolean)reader.nextKeyValue());
        reader.close();
    }

    static {
        tableName = TableName.valueOf((String)TestHLogRecordReader.getName());
        rowName = tableName.getName();
        info = new HRegionInfo(tableName, Bytes.toBytes((String)""), Bytes.toBytes((String)""), false);
        family = Bytes.toBytes((String)"column");
        value = Bytes.toBytes((String)"value");
    }
}

