// Autogenerated Jamon implementation
// /root/builds/opensource/hbase-0.98.12/dl/mapr-hbase-0.98/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 33, 1
import java.util.*;
// 34, 1
import org.apache.hadoop.util.StringUtils;
// 35, 1
import org.apache.hadoop.hbase.util.Bytes;
// 36, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 37, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 38, 1
import org.apache.hadoop.hbase.master.HMaster;
// 39, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 40, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 41, 1
import org.apache.hadoop.hbase.HConstants;
// 42, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 43, 1
import org.apache.hadoop.hbase.ServerLoad;
// 44, 1
import org.apache.hadoop.hbase.ServerName;
// 45, 1
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 46, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 47, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 48, 1
import org.apache.hadoop.hbase.master.RegionState;
// 49, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 50, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 51, 1
import org.apache.hadoop.hbase.TableName;
// 52, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;
// 53, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 54, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 55, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 56, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final HBaseAdmin admin;
  private final AssignmentManager assignmentManager;
  private final String format;
  private final boolean catalogJanitorEnabled;
  private final List<ServerName> servers;
  private final ServerName metaLocation;
  private final Set<ServerName> deadServers;
  private final ServerManager serverManager;
  private final Map<String,Integer> frags;
  private final String filter;
  // 68, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeperWatcher().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    admin = p_implData.getAdmin();
    assignmentManager = p_implData.getAssignmentManager();
    format = p_implData.getFormat();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    servers = p_implData.getServers();
    metaLocation = p_implData.getMetaLocation();
    deadServers = p_implData.getDeadServers();
    serverManager = p_implData.getServerManager();
    frags = p_implData.getFrags();
    filter = p_implData.getFilter();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 59, 1
    if (format.equals("json") )
    {
      // 59, 30
      jamonWriter.write("\n  ");
      // 60, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 60, 68
      jamonWriter.write("\n  ");
      // 61, 3
      return; 
    }
    // 62, 7
    jamonWriter.write("\n");
    // 63, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 95, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Master: ");
    // 102, 20
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 102, 62
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 130, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 130, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 132, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container\">\n\t");
    // 139, 2
    if (master.isActiveMaster() )
    {
      // 139, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 142, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 142, 77
      jamonWriter.write(" </small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 148, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 148, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 150, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 150, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
      }
      // 155, 15
      jamonWriter.write("\n        ");
      // 156, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 156, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 161, 15
      jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 165, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_1.setServers(servers );
        __jamon__var_1.renderNoFlush(jamonWriter, master);
      }
      // 165, 74
      jamonWriter.write("\n\n            ");
      // 167, 13
      if ((deadServers != null) )
      {
        // 167, 42
        jamonWriter.write("\n                ");
        // 168, 17
        {
          // 168, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 168, 40
        jamonWriter.write("\n            ");
      }
      // 169, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 172, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_2.renderNoFlush(jamonWriter, master );
      }
      // 172, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 190, 25
      if ((metaLocation != null) )
      {
        // 190, 55
        jamonWriter.write("\n                            ");
        // 191, 29
        {
          // 191, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 191, 45
        jamonWriter.write("\n                        ");
      }
      // 192, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 195, 25
      if ((metaLocation != null) )
      {
        // 195, 55
        jamonWriter.write("\n                            ");
        // 196, 29
        {
          // 196, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 196, 48
        jamonWriter.write("\n                        ");
      }
      // 197, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 200, 25
      {
        // 200, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 200, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
      // 205, 9
      {
        org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
        __jamon__var_3.renderNoFlush(jamonWriter, master.getAssignmentManager());
      }
      // 205, 90
      jamonWriter.write("\n\t");
    }
    // 206, 2
    else
    {
      // 206, 9
      jamonWriter.write("\n        <section>\n            ");
      // 208, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, master );
      }
      // 208, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 210, 8
    jamonWriter.write("    \n\n\n        <section>\n            ");
    // 214, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_5.setFilter(filter );
      __jamon__var_5.renderNoFlush(jamonWriter);
    }
    // 214, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 227, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 227, 84
    jamonWriter.write(", r");
    // 227, 87
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 227, 147
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 231, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 231, 81
    jamonWriter.write(", ");
    // 231, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 231, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 236, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 236, 78
    jamonWriter.write(", r");
    // 236, 81
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 236, 135
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 241, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 241, 75
    jamonWriter.write(", ");
    // 241, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 241, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
    // 247, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 247, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Base Path</td>\n                    <td> ");
    // 252, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getBaseZNode()), jamonWriter);
    // 252, 68
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 257, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 257, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 262, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 262, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 265, 17
    if (master.isActiveMaster() )
    {
      // 265, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 268, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 268, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 273, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 273, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 278, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 278, 103
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 281, 18
      if (frags != null )
      {
        // 281, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 284, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 284, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 287, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 290, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(master.getCoprocessors())), jamonWriter);
      // 290, 83
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n                ");
    }
    // 293, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
  }
  
  
  // 401, 1
  private void __jamon_innerUnit__userSnapshots(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 402, 1
    
   List<SnapshotDescription> snapshots = admin.listSnapshots();

    // 405, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 405, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 412, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 412, 57
        jamonWriter.write("\n    ");
        // 413, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 416, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 417, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 417, 68
        jamonWriter.write("\">");
        // 417, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 417, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 418, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 418, 74
        jamonWriter.write("\">");
        // 418, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 418, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 420, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 420, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 422, 12
      jamonWriter.write("\n    <p>");
      // 423, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 423, 30
      jamonWriter.write(" snapshot(s) in set.</p>\n</table>\n");
    }
    // 425, 7
    jamonWriter.write("\n");
  }
  
  
  // 305, 1
  private void __jamon_innerUnit__catalogTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 306, 1
    
 HTableDescriptor[] sysTables = admin.listTableDescriptorsByNamespace(NamespaceDescriptor
 .SYSTEM_NAMESPACE_NAME_STR);

    // 311, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
    // 314, 5
    if ((frags != null) )
    {
      // 314, 28
      jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
    }
    // 316, 11
    jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
    // 319, 1
    for (HTableDescriptor systemTable : sysTables)
    {
      // 319, 49
      jamonWriter.write("\n<tr>\n");
      // 321, 1
      TableName tableName = systemTable.getTableName();
      // 322, 5
      jamonWriter.write("<td><a href=\"table.jsp?name=");
      // 322, 33
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
      // 322, 48
      jamonWriter.write("\">");
      // 322, 50
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
      // 322, 65
      jamonWriter.write("</a></td>\n    ");
      // 323, 5
      if ((frags != null))
      {
        // 323, 27
        jamonWriter.write("\n        <td align=\"center\">");
        // 324, 28
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
        // 325, 37
        jamonWriter.write("</td>\n    ");
      }
      // 326, 11
      jamonWriter.write("\n    ");
      // 327, 5
      String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl";
	 } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
	     description = "The hbase:labels table holds information about visibility labels";
        } else {
            description = "The .NAMESPACE. table holds information about namespaces.";
        }
    
      // 338, 5
      jamonWriter.write("<td>");
      // 338, 9
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
      // 338, 26
      jamonWriter.write("</td>\n</tr>\n");
    }
    // 340, 8
    jamonWriter.write("\n</table>\n");
  }
  
  
  // 344, 1
  private void __jamon_innerUnit__userTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 345, 1
    
   HTableDescriptor[] tables = admin.listTables();

    // 348, 1
    if ((tables != null && tables.length > 0))
    {
      // 348, 45
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
      // 353, 9
      if ((frags != null) )
      {
        // 353, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 355, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Offline Regions</th>\n        <th>Failed Regions</th>\n        <th>Split Regions</th>\n        <th>Other Regions</th>\n        <th>Description</th>\n    </tr>\n    ");
      // 363, 5
      for (HTableDescriptor htDesc : tables)
      {
        // 363, 45
        jamonWriter.write("\n    ");
        // 364, 5
        
      Map<RegionState.State, List<HRegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(htDesc.getTableName());
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<HRegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount;
    
        // 382, 5
        jamonWriter.write("<tr>\n        <td>");
        // 383, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNamespaceAsString()), jamonWriter);
        // 383, 63
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 384, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNameAsString()), jamonWriter);
        // 384, 81
        jamonWriter.write(">");
        // 384, 82
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getQualifierAsString()), jamonWriter);
        // 384, 132
        jamonWriter.write("</a> </td>\n        ");
        // 385, 9
        if ((frags != null) )
        {
          // 385, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 386, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(htDesc.getTableName().getNameAsString()) != null ? frags.get(htDesc.getTableName().getQualifierAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 386, 179
          jamonWriter.write("</td>\n        ");
        }
        // 387, 15
        jamonWriter.write("\n        <td>");
        // 388, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 388, 35
        jamonWriter.write("</td>\n        <td>");
        // 389, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 389, 38
        jamonWriter.write("</td>\n        <td>");
        // 390, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 390, 37
        jamonWriter.write("</td>\n        <td>");
        // 391, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 391, 36
        jamonWriter.write("</td>\n        <td>");
        // 392, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 392, 36
        jamonWriter.write("</td>\n        <td>");
        // 393, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 393, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 395, 12
      jamonWriter.write("\n    <p>");
      // 396, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 396, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
    }
    // 398, 7
    jamonWriter.write("\n");
  }
  
  
  // 429, 1
  private void __jamon_innerUnit__deadRegionServers(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 431, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 431, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 439, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 445, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 447, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 447, 33
      jamonWriter.write("</td>\n        <td>");
      // 448, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 448, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 450, 5
      
        }
    
      // 453, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 455, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 455, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 459, 7
    jamonWriter.write("\n");
    // 460, 1
    
   HConnectionManager.deleteConnection(admin.getConfiguration());

  }
  
  
}
