/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsCache;

@InterfaceAudience.Private
public class FeedUserAuthScanLabelGenerator
implements ScanLabelGenerator {
    private static final Log LOG = LogFactory.getLog(FeedUserAuthScanLabelGenerator.class);
    private Configuration conf;
    private VisibilityLabelsCache labelsCache = VisibilityLabelsCache.get();

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<String> getLabels(User user, Authorizations authorizations) {
        if (authorizations == null || authorizations.getLabels() == null || authorizations.getLabels().isEmpty()) {
            String userName = user.getShortName();
            HashSet<String> auths = new HashSet<String>();
            auths.addAll(this.labelsCache.getUserAuths(userName));
            auths.addAll(this.labelsCache.getGroupAuths(user.getGroupNames()));
            return new ArrayList<String>(auths);
        }
        return authorizations.getLabels();
    }
}

