/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;

@InterfaceAudience.Private
public class ReplicationHLogReaderManager {
    private static final Log LOG = LogFactory.getLog(ReplicationHLogReaderManager.class);
    private final FileSystem fs;
    private final Configuration conf;
    private long position = 0L;
    private HLog.Reader reader;
    private Path lastPath;

    public ReplicationHLogReaderManager(FileSystem fs, Configuration conf) {
        this.fs = fs;
        this.conf = conf;
    }

    public HLog.Reader openReader(Path path) throws IOException {
        if (this.reader == null || !this.lastPath.equals((Object)path)) {
            this.closeReader();
            this.reader = HLogFactory.createReader(this.fs, path, this.conf);
            this.lastPath = path;
        } else {
            try {
                this.reader.reset();
            }
            catch (NullPointerException npe) {
                throw new IOException("NPE resetting reader, likely HDFS-4380", npe);
            }
        }
        return this.reader;
    }

    public HLog.Entry readNextAndSetPosition() throws IOException {
        HLog.Entry entry = this.reader.next();
        this.position = this.reader.getPosition();
        if (entry != null) {
            entry.setCompressionContext(null);
        }
        return entry;
    }

    public void seek() throws IOException {
        if (this.position != 0L) {
            this.reader.seek(this.position);
        }
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    void finishCurrentFile() {
        this.position = 0L;
        try {
            this.closeReader();
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to close reader", (Throwable)e);
        }
    }
}

