/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.mapreduce.DefaultVisibilityExpressionResolver;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.VisibilityExpressionResolver;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CellCreator {
    protected static final Log LOG = LogFactory.getLog(CellCreator.class);
    @InterfaceStability.Unstable
    public static final String VISIBILITY_EXP_RESOLVER_CLASS = "hbase.mapreduce.visibility.expression.resolver.class";
    private VisibilityExpressionResolver visExpResolver;

    public CellCreator(Configuration conf) {
        if (TableMapReduceUtil.getMapRTablePath(conf) != null) {
            LOG.info((Object)"The job is configured with a MapR-DB table. Visibility Labels will not be added to the Cells");
        } else {
            Class clazz = conf.getClass(VISIBILITY_EXP_RESOLVER_CLASS, DefaultVisibilityExpressionResolver.class, VisibilityExpressionResolver.class);
            this.visExpResolver = (VisibilityExpressionResolver)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
            this.visExpResolver.init();
        }
    }

    public Cell create(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, byte[] value, int voffset, int vlength) throws IOException {
        return this.create(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, value, voffset, vlength, (List<Tag>)null);
    }

    @Deprecated
    public Cell create(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, byte[] value, int voffset, int vlength, String visExpression) throws IOException {
        List<Tag> visTags = null;
        if (this.visExpResolver != null && visExpression != null) {
            visTags = this.visExpResolver.createVisibilityExpTags(visExpression);
        }
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, KeyValue.Type.Put, value, voffset, vlength, visTags);
    }

    public Cell create(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, long timestamp, byte[] value, int voffset, int vlength, List<Tag> tags) throws IOException {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, timestamp, KeyValue.Type.Put, value, voffset, vlength, tags);
    }

    @InterfaceStability.Unstable
    public VisibilityExpressionResolver getVisibilityExpressionResolver() {
        return this.visExpResolver;
    }
}

