/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class MetaEditor {
    private static final Log LOG = LogFactory.getLog(MetaEditor.class);

    public static Put makePutFromRegionInfo(HRegionInfo regionInfo) throws IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaEditor.addRegionInfo(put, regionInfo);
        return put;
    }

    public static Delete makeDeleteFromRegionInfo(HRegionInfo regionInfo) {
        if (regionInfo == null) {
            throw new IllegalArgumentException("Can't make a delete for null region");
        }
        Delete delete = new Delete(regionInfo.getRegionName());
        return delete;
    }

    public static Put addDaughtersToPut(Put put, HRegionInfo splitA, HRegionInfo splitB) {
        if (splitA != null) {
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, splitA.toByteArray());
        }
        if (splitB != null) {
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, splitB.toByteArray());
        }
        return put;
    }

    static void putToMetaTable(CatalogTracker ct, Put p) throws IOException {
        MetaEditor.put(MetaReader.getMetaHTable((CatalogTracker)ct), p);
    }

    static void putToCatalogTable(CatalogTracker ct, Put p) throws IOException {
        MetaEditor.put(MetaReader.getCatalogHTable((CatalogTracker)ct), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(HTable t, Put p) throws IOException {
        try {
            t.put(p);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putsToMetaTable(CatalogTracker ct, List<Put> ps) throws IOException {
        HTable t = MetaReader.getMetaHTable((CatalogTracker)ct);
        try {
            t.put(ps);
        }
        finally {
            t.close();
        }
    }

    static void deleteFromMetaTable(CatalogTracker ct, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaEditor.deleteFromMetaTable(ct, dels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromMetaTable(CatalogTracker ct, List<Delete> deletes) throws IOException {
        HTable t = MetaReader.getMetaHTable((CatalogTracker)ct);
        try {
            t.delete(deletes);
        }
        finally {
            t.close();
        }
    }

    public static void mutateMetaTable(CatalogTracker ct, List<Mutation> mutations) throws IOException {
        HTable t = MetaReader.getMetaHTable((CatalogTracker)ct);
        try {
            t.batch(mutations);
        }
        catch (InterruptedException e) {
            InterruptedIOException ie = new InterruptedIOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        finally {
            t.close();
        }
    }

    public static void addRegionToMeta(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        MetaEditor.putToMetaTable(catalogTracker, MetaEditor.makePutFromRegionInfo(regionInfo));
        LOG.info((Object)("Added " + regionInfo.getRegionNameAsString()));
    }

    public static void addRegionToMeta(HTable meta, HRegionInfo regionInfo) throws IOException {
        MetaEditor.addRegionToMeta(meta, regionInfo, null, null);
    }

    public static void addRegionToMeta(HTable meta, HRegionInfo regionInfo, HRegionInfo splitA, HRegionInfo splitB) throws IOException {
        Put put = MetaEditor.makePutFromRegionInfo(regionInfo);
        MetaEditor.addDaughtersToPut(put, splitA, splitB);
        meta.put(put);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added " + regionInfo.getRegionNameAsString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMeta(CatalogTracker catalogTracker, HRegionInfo regionInfo, HRegionInfo splitA, HRegionInfo splitB) throws IOException {
        HTable meta = MetaReader.getMetaHTable((CatalogTracker)catalogTracker);
        try {
            MetaEditor.addRegionToMeta(meta, regionInfo, splitA, splitB);
        }
        finally {
            meta.close();
        }
    }

    public static void addRegionsToMeta(CatalogTracker catalogTracker, List<HRegionInfo> regionInfos) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (HRegionInfo regionInfo : regionInfos) {
            puts.add(MetaEditor.makePutFromRegionInfo(regionInfo));
        }
        MetaEditor.putsToMetaTable(catalogTracker, puts);
        LOG.info((Object)("Added " + puts.size()));
    }

    public static void addDaughter(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn, long openSeqNum) throws NotAllMetaRegionsOnlineException, IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaEditor.addRegionInfo(put, regionInfo);
        if (sn != null) {
            MetaEditor.addLocation(put, sn, openSeqNum);
        }
        MetaEditor.putToMetaTable(catalogTracker, put);
        LOG.info((Object)("Added daughter " + regionInfo.getEncodedName() + (sn == null ? ", serverName=null" : ", serverName=" + sn.toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeRegions(CatalogTracker catalogTracker, HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName sn) throws IOException {
        HTable meta = MetaReader.getMetaHTable((CatalogTracker)catalogTracker);
        try {
            HRegionInfo copyOfMerged = new HRegionInfo(mergedRegion);
            Put putOfMerged = MetaEditor.makePutFromRegionInfo(copyOfMerged);
            putOfMerged.addImmutable(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER, regionA.toByteArray());
            putOfMerged.addImmutable(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER, regionB.toByteArray());
            Delete deleteA = MetaEditor.makeDeleteFromRegionInfo(regionA);
            Delete deleteB = MetaEditor.makeDeleteFromRegionInfo(regionB);
            MetaEditor.addLocation(putOfMerged, sn, 1L);
            byte[] tableRow = Bytes.toBytes((String)(mergedRegion.getRegionNameAsString() + 44));
            MetaEditor.multiMutate(meta, tableRow, new Mutation[]{putOfMerged, deleteA, deleteB});
        }
        finally {
            meta.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitRegion(CatalogTracker catalogTracker, HRegionInfo parent, HRegionInfo splitA, HRegionInfo splitB, ServerName sn) throws IOException {
        HTable meta = MetaReader.getMetaHTable((CatalogTracker)catalogTracker);
        try {
            HRegionInfo copyOfParent = new HRegionInfo(parent);
            copyOfParent.setOffline(true);
            copyOfParent.setSplit(true);
            Put putParent = MetaEditor.makePutFromRegionInfo(copyOfParent);
            MetaEditor.addDaughtersToPut(putParent, splitA, splitB);
            Put putA = MetaEditor.makePutFromRegionInfo(splitA);
            Put putB = MetaEditor.makePutFromRegionInfo(splitB);
            MetaEditor.addLocation(putA, sn, 1L);
            MetaEditor.addLocation(putB, sn, 1L);
            byte[] tableRow = Bytes.toBytes((String)(parent.getRegionNameAsString() + 44));
            MetaEditor.multiMutate(meta, tableRow, new Mutation[]{putParent, putA, putB});
        }
        finally {
            meta.close();
        }
    }

    private static void multiMutate(HTable table, byte[] row, Mutation ... mutations) throws IOException {
        CoprocessorRpcChannel channel = table.coprocessorService(row);
        MultiRowMutationProtos.MutateRowsRequest.Builder mmrBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        for (Mutation mutation : mutations) {
            if (mutation instanceof Put) {
                mmrBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                mmrBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation));
                continue;
            }
            throw new DoNotRetryIOException("multi in MetaEditor doesn't support " + mutation.getClass().getName());
        }
        MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
        try {
            service.mutateRows(null, mmrBuilder.build());
        }
        catch (ServiceException ex) {
            ProtobufUtil.toIOException((ServiceException)ex);
        }
    }

    public static void updateMetaLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn, long openSeqNum) throws IOException, ConnectException {
        MetaEditor.updateLocation(catalogTracker, regionInfo, sn, openSeqNum);
    }

    public static void updateRegionLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn, long updateSeqNum) throws IOException {
        MetaEditor.updateLocation(catalogTracker, regionInfo, sn, updateSeqNum);
    }

    private static void updateLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn, long openSeqNum) throws IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaEditor.addLocation(put, sn, openSeqNum);
        MetaEditor.putToCatalogTable(catalogTracker, put);
        LOG.info((Object)("Updated row " + regionInfo.getRegionNameAsString() + " with server=" + sn));
    }

    public static void deleteRegion(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        Delete delete = new Delete(regionInfo.getRegionName());
        MetaEditor.deleteFromMetaTable(catalogTracker, delete);
        LOG.info((Object)("Deleted " + regionInfo.getRegionNameAsString()));
    }

    public static void deleteRegions(CatalogTracker catalogTracker, List<HRegionInfo> regionsInfo) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(regionsInfo.size());
        for (HRegionInfo hri : regionsInfo) {
            deletes.add(new Delete(hri.getRegionName()));
        }
        MetaEditor.deleteFromMetaTable(catalogTracker, deletes);
        LOG.info((Object)("Deleted " + regionsInfo));
    }

    public static void mutateRegions(CatalogTracker catalogTracker, List<HRegionInfo> regionsToRemove, List<HRegionInfo> regionsToAdd) throws IOException {
        ArrayList<Mutation> mutation = new ArrayList<Mutation>();
        if (regionsToRemove != null) {
            for (HRegionInfo hri : regionsToRemove) {
                mutation.add((Mutation)new Delete(hri.getRegionName()));
            }
        }
        if (regionsToAdd != null) {
            for (HRegionInfo hri : regionsToAdd) {
                mutation.add((Mutation)MetaEditor.makePutFromRegionInfo(hri));
            }
        }
        MetaEditor.mutateMetaTable(catalogTracker, mutation);
        if (regionsToRemove != null && regionsToRemove.size() > 0) {
            LOG.debug((Object)("Deleted " + regionsToRemove));
        }
        if (regionsToAdd != null && regionsToAdd.size() > 0) {
            LOG.debug((Object)("Added " + regionsToAdd));
        }
    }

    public static void overwriteRegions(CatalogTracker catalogTracker, List<HRegionInfo> regionInfos) throws IOException {
        MetaEditor.deleteRegions(catalogTracker, regionInfos);
        Threads.sleep((long)20L);
        MetaEditor.addRegionsToMeta(catalogTracker, regionInfos);
        LOG.info((Object)("Overwritten " + regionInfos));
    }

    public static void deleteMergeQualifiers(CatalogTracker catalogTracker, HRegionInfo mergedRegion) throws IOException {
        Delete delete = new Delete(mergedRegion.getRegionName());
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER);
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER);
        MetaEditor.deleteFromMetaTable(catalogTracker, delete);
        LOG.info((Object)("Deleted references in merged region " + mergedRegion.getRegionNameAsString() + ", qualifier=" + Bytes.toStringBinary((byte[])HConstants.MERGEA_QUALIFIER) + " and qualifier=" + Bytes.toStringBinary((byte[])HConstants.MERGEB_QUALIFIER)));
    }

    private static Put addRegionInfo(Put p, HRegionInfo hri) throws IOException {
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, hri.toByteArray());
        return p;
    }

    private static Put addLocation(Put p, ServerName sn, long openSeqNum) {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, now, Bytes.toBytes((String)sn.getHostAndPort()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, now, Bytes.toBytes((long)sn.getStartcode()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, now, Bytes.toBytes((long)openSeqNum));
        return p;
    }
}

