/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public abstract class HBaseTestCase
extends TestCase {
    private static final Log LOG = LogFactory.getLog(HBaseTestCase.class);
    protected static final byte[] fam1 = Bytes.toBytes((String)"colfamily11");
    protected static final byte[] fam2 = Bytes.toBytes((String)"colfamily21");
    protected static final byte[] fam3 = Bytes.toBytes((String)"colfamily31");
    protected static final byte[][] COLUMNS = new byte[][]{fam1, fam2, fam3};
    private boolean localfs = false;
    protected static Path testDir = null;
    protected FileSystem fs = null;
    protected HRegion meta = null;
    protected static final char FIRST_CHAR = 'a';
    protected static final char LAST_CHAR = 'z';
    protected static final String PUNCTUATION = "~`@#$%^&*()-_+=:;',.<>/?[]{}|";
    protected static final byte[] START_KEY_BYTES = new byte[]{97, 97, 97};
    protected String START_KEY = new String(START_KEY_BYTES, HConstants.UTF8_CHARSET);
    protected static final int MAXVERSIONS = 3;
    protected final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    public volatile Configuration conf = HBaseConfiguration.create();
    public final FSTableDescriptors fsTableDescriptors;

    public HBaseTestCase() {
        try {
            this.fsTableDescriptors = new FSTableDescriptors(this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init descriptors", e);
        }
    }

    public HBaseTestCase(String name) {
        super(name);
        try {
            this.fsTableDescriptors = new FSTableDescriptors(this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init descriptors", e);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        boolean bl = this.localfs = this.conf.get("fs.defaultFS", "file:///").compareTo("file:///") == 0;
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.conf);
        }
        try {
            if (this.localfs) {
                testDir = this.getUnitTestdir(this.getName());
                if (this.fs.exists(testDir)) {
                    this.fs.delete(testDir, true);
                }
            } else {
                testDir = FSUtils.getRootDir((Configuration)this.conf);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"error during setup", (Throwable)e);
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        try {
            if (this.localfs && this.fs.exists(testDir)) {
                this.fs.delete(testDir, true);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"error during tear down", (Throwable)e);
        }
        super.tearDown();
    }

    protected Path getUnitTestdir(String testName) {
        return this.testUtil.getDataTestDir(testName);
    }

    public HRegion createNewHRegion(HTableDescriptor desc, byte[] startKey, byte[] endKey) throws IOException {
        return this.createNewHRegion(desc, startKey, endKey, this.conf);
    }

    public HRegion createNewHRegion(HTableDescriptor desc, byte[] startKey, byte[] endKey, Configuration conf) throws IOException {
        HRegionInfo hri = new HRegionInfo(desc.getTableName(), startKey, endKey);
        return HRegion.createHRegion((HRegionInfo)hri, (Path)testDir, (Configuration)conf, (HTableDescriptor)desc);
    }

    protected HRegion openClosedRegion(HRegion closedRegion) throws IOException {
        return HRegion.openHRegion((HRegion)closedRegion, null);
    }

    protected HTableDescriptor createTableDescriptor(String name) {
        return this.createTableDescriptor(name, 3);
    }

    protected HTableDescriptor createTableDescriptor(String name, int versions) {
        return this.createTableDescriptor(name, 0, versions, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_KEEP_DELETED);
    }

    protected HTableDescriptor createTableDescriptor(String name, int minVersions, int versions, int ttl, KeepDeletedCells keepDeleted) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)name));
        for (byte[] cfName : new byte[][]{fam1, fam2, fam3}) {
            htd.addFamily(new HColumnDescriptor(cfName).setMinVersions(minVersions).setMaxVersions(versions).setKeepDeletedCells(keepDeleted).setBlockCacheEnabled(false).setTimeToLive(ttl));
        }
        return htd;
    }

    public static long addContent(HRegion r, byte[] columnFamily, byte[] column) throws IOException {
        byte[] startKey = r.getRegionInfo().getStartKey();
        byte[] endKey = r.getRegionInfo().getEndKey();
        byte[] startKeyBytes = startKey;
        if (startKeyBytes == null || startKeyBytes.length == 0) {
            startKeyBytes = START_KEY_BYTES;
        }
        return HBaseTestCase.addContent(new HRegionIncommon(r), Bytes.toString((byte[])columnFamily), Bytes.toString((byte[])column), startKeyBytes, endKey, -1L);
    }

    public static long addContent(HRegion r, byte[] columnFamily) throws IOException {
        return HBaseTestCase.addContent(r, columnFamily, null);
    }

    public static long addContent(Incommon updater, String columnFamily) throws IOException {
        return HBaseTestCase.addContent(updater, columnFamily, START_KEY_BYTES, null);
    }

    public static long addContent(Incommon updater, String family, String column) throws IOException {
        return HBaseTestCase.addContent(updater, family, column, START_KEY_BYTES, null);
    }

    public static long addContent(Incommon updater, String columnFamily, byte[] startKeyBytes, byte[] endKey) throws IOException {
        return HBaseTestCase.addContent(updater, columnFamily, null, startKeyBytes, endKey, -1L);
    }

    public static long addContent(Incommon updater, String family, String column, byte[] startKeyBytes, byte[] endKey) throws IOException {
        return HBaseTestCase.addContent(updater, family, column, startKeyBytes, endKey, -1L);
    }

    public static long addContent(Incommon updater, String columnFamily, String column, byte[] startKeyBytes, byte[] endKey, long ts) throws IOException {
        long count = 0L;
        int secondCharStart = startKeyBytes[1];
        int thirdCharStart = startKeyBytes[2];
        block6: for (char c = (char)startKeyBytes[0]; c <= 'z'; c = (char)(c + '\u0001')) {
            for (int d = secondCharStart; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = thirdCharStart; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] t = new byte[]{(byte)c, (byte)d, (byte)e};
                    if (endKey != null && endKey.length > 0 && Bytes.compareTo((byte[])endKey, (byte[])t) <= 0) break block6;
                    try {
                        Put put = ts != -1L ? new Put(t, ts) : new Put(t);
                        try {
                            StringBuilder sb = new StringBuilder();
                            if (column != null && column.contains(":")) {
                                sb.append(column);
                            } else if (columnFamily != null) {
                                sb.append(columnFamily);
                                if (!columnFamily.endsWith(":")) {
                                    sb.append(":");
                                }
                                if (column != null) {
                                    sb.append(column);
                                }
                            }
                            byte[][] split = KeyValue.parseColumn((byte[])Bytes.toBytes((String)sb.toString()));
                            if (split.length == 1) {
                                put.add(split[0], new byte[0], t);
                            } else {
                                put.add(split[0], split[1], t);
                            }
                            put.setDurability(Durability.SKIP_WAL);
                            updater.put(put);
                            ++count;
                            continue;
                        }
                        catch (RuntimeException ex) {
                            ex.printStackTrace();
                            throw ex;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            throw ex;
                        }
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                        throw ex;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        throw ex;
                    }
                }
                thirdCharStart = 97;
            }
            secondCharStart = 97;
        }
        return count;
    }

    protected void assertResultEquals(HRegion region, byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) throws IOException {
        Get get = new Get(row);
        get.setTimeStamp(timestamp);
        Result res = region.get(get);
        NavigableMap map = res.getMap();
        byte[] res_value = (byte[])((NavigableMap)((NavigableMap)map.get(family)).get(qualifier)).get(timestamp);
        if (value == null) {
            HBaseTestCase.assertEquals((String)(Bytes.toString((byte[])family) + " " + Bytes.toString((byte[])qualifier) + " at timestamp " + timestamp), null, (Object)res_value);
        } else {
            if (res_value == null) {
                HBaseTestCase.fail((String)(Bytes.toString((byte[])family) + " " + Bytes.toString((byte[])qualifier) + " at timestamp " + timestamp + "\" was expected to be \"" + Bytes.toStringBinary((byte[])value) + " but was null"));
            }
            if (res_value != null) {
                HBaseTestCase.assertEquals((String)(Bytes.toString((byte[])family) + " " + Bytes.toString((byte[])qualifier) + " at timestamp " + timestamp), (Object)value, (Object)new String(res_value));
            }
        }
    }

    public static void shutdownDfs(MiniDFSCluster cluster) {
        if (cluster != null) {
            LOG.info((Object)"Shutting down Mini DFS ");
            try {
                cluster.shutdown();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                DistributedFileSystem fs = cluster.getFileSystem();
                if (fs != null) {
                    LOG.info((Object)"Shutting down FileSystem");
                    fs.close();
                }
                FileSystem.closeAll();
            }
            catch (IOException e) {
                LOG.error((Object)"error closing file system", (Throwable)e);
            }
        }
    }

    protected void createMetaRegion() throws IOException {
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(this.conf);
        this.meta = HRegion.createHRegion((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (Path)testDir, (Configuration)this.conf, (HTableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME));
    }

    protected void closeRootAndMeta() throws IOException {
        HRegion.closeHRegion((HRegion)this.meta);
    }

    public static void assertByteEquals(byte[] expected, byte[] actual) {
        if (Bytes.compareTo((byte[])expected, (byte[])actual) != 0) {
            throw new AssertionFailedError("expected:<" + Bytes.toString((byte[])expected) + "> but was:<" + Bytes.toString((byte[])actual) + ">");
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        if (Bytes.compareTo((byte[])expected, (byte[])actual) != 0) {
            throw new AssertionFailedError("expected:<" + Bytes.toStringBinary((byte[])expected) + "> but was:<" + Bytes.toStringBinary((byte[])actual) + ">");
        }
    }

    public static class InternalScannerIncommon
    implements ScannerIncommon {
        InternalScanner scanner;

        public InternalScannerIncommon(InternalScanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public boolean next(List<Cell> results) throws IOException {
            return this.scanner.next(results);
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }

        @Override
        public Iterator<Result> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ClientScannerIncommon
    implements ScannerIncommon {
        ResultScanner scanner;

        public ClientScannerIncommon(ResultScanner scanner) {
            this.scanner = scanner;
        }

        @Override
        public boolean next(List<Cell> values) throws IOException {
            Result results = this.scanner.next();
            if (results == null) {
                return false;
            }
            values.clear();
            values.addAll(results.listCells());
            return true;
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
        }

        @Override
        public Iterator<Result> iterator() {
            return this.scanner.iterator();
        }
    }

    public static interface ScannerIncommon
    extends Iterable<Result> {
        public boolean next(List<Cell> var1) throws IOException;

        public void close() throws IOException;
    }

    public static class HTableIncommon
    implements Incommon {
        final HTable table;

        public HTableIncommon(HTable table) {
            this.table = table;
        }

        @Override
        public void put(Put put) throws IOException {
            this.table.put(put);
        }

        @Override
        public void delete(Delete delete, boolean writeToWAL) throws IOException {
            this.table.delete(delete);
        }

        @Override
        public Result get(Get get) throws IOException {
            return this.table.get(get);
        }

        @Override
        public ScannerIncommon getScanner(byte[] family, byte[][] qualifiers, byte[] firstRow, long ts) throws IOException {
            Scan scan = new Scan(firstRow);
            if (qualifiers == null || qualifiers.length == 0) {
                scan.addFamily(family);
            } else {
                for (int i = 0; i < qualifiers.length; ++i) {
                    scan.addColumn(HConstants.CATALOG_FAMILY, qualifiers[i]);
                }
            }
            scan.setTimeRange(0L, ts);
            return new ClientScannerIncommon(this.table.getScanner(scan));
        }
    }

    public static class HRegionIncommon
    implements Incommon,
    FlushCache {
        final HRegion region;

        public HRegionIncommon(HRegion HRegion2) {
            this.region = HRegion2;
        }

        @Override
        public void put(Put put) throws IOException {
            this.region.put(put);
        }

        @Override
        public void delete(Delete delete, boolean writeToWAL) throws IOException {
            this.region.delete(delete);
        }

        @Override
        public Result get(Get get) throws IOException {
            return this.region.get(get);
        }

        @Override
        public ScannerIncommon getScanner(byte[] family, byte[][] qualifiers, byte[] firstRow, long ts) throws IOException {
            Scan scan = new Scan(firstRow);
            if (qualifiers == null || qualifiers.length == 0) {
                scan.addFamily(family);
            } else {
                for (int i = 0; i < qualifiers.length; ++i) {
                    scan.addColumn(HConstants.CATALOG_FAMILY, qualifiers[i]);
                }
            }
            scan.setTimeRange(0L, ts);
            return new InternalScannerIncommon((InternalScanner)this.region.getScanner(scan));
        }

        @Override
        public void flushcache() throws IOException {
            this.region.flushcache();
        }
    }

    public static interface Incommon {
        public void delete(Delete var1, boolean var2) throws IOException;

        public void put(Put var1) throws IOException;

        public Result get(Get var1) throws IOException;

        public ScannerIncommon getScanner(byte[] var1, byte[][] var2, byte[] var3, long var4) throws IOException;
    }

    public static interface FlushCache {
        public void flushcache() throws IOException;
    }
}

