/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.test;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.test.LoadTestKVGenerator;

@InterfaceAudience.Private
public abstract class LoadTestDataGenerator {
    protected LoadTestKVGenerator kvGenerator;
    public static final byte[] MUTATE_INFO = "mutate_info".getBytes();
    public static final byte[] INCREMENT = "increment".getBytes();
    protected String[] args;

    public LoadTestDataGenerator() {
    }

    public LoadTestDataGenerator(int minValueSize, int maxValueSize) {
        this.kvGenerator = new LoadTestKVGenerator(minValueSize, maxValueSize);
    }

    public void initialize(String[] args) {
        this.args = args;
    }

    public abstract byte[] getDeterministicUniqueKey(long var1);

    public abstract byte[][] getColumnFamilies();

    public abstract byte[][] generateColumnsForCf(byte[] var1, byte[] var2);

    public abstract byte[] generateValue(byte[] var1, byte[] var2, byte[] var3);

    public abstract boolean verify(byte[] var1, byte[] var2, Set<byte[]> var3);

    public abstract boolean verify(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public Mutation beforeMutate(long rowkeyBase, Mutation m) throws IOException {
        return m;
    }

    public Get beforeGet(long rowkeyBase, Get get) throws IOException {
        return get;
    }

    public String[] getArgs() {
        return this.args;
    }
}

