/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.ByteString;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.jersey.api.json.JSONUnmarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.ScannerMessage;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@XmlRootElement(name="Scanner")
@InterfaceAudience.Private
public class ScannerModel
implements ProtobufMessageHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] endRow = HConstants.EMPTY_END_ROW;
    private List<byte[]> columns = new ArrayList<byte[]>();
    private int batch = Integer.MAX_VALUE;
    private long startTime = 0L;
    private long endTime = Long.MAX_VALUE;
    private String filter = null;
    private int maxVersions = Integer.MAX_VALUE;
    private int caching = -1;
    private List<String> labels = new ArrayList<String>();
    private boolean cacheBlocks = true;
    private static final byte[] COLUMN_DIVIDER = Bytes.toBytes((String)":");

    public static Filter buildFilter(String s) throws Exception {
        JSONJAXBContext context = new JSONJAXBContext(JSONConfiguration.natural().build(), new Class[]{FilterModel.class});
        JSONUnmarshaller unmarshaller = context.createJSONUnmarshaller();
        FilterModel model = (FilterModel)unmarshaller.unmarshalFromJSON((Reader)new StringReader(s), FilterModel.class);
        return model.build();
    }

    public static String stringifyFilter(Filter filter) throws Exception {
        JSONJAXBContext context = new JSONJAXBContext(JSONConfiguration.natural().build(), new Class[]{FilterModel.class});
        JSONMarshaller marshaller = context.createJSONMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshallToJSON((Object)new FilterModel(filter), (Writer)writer);
        return writer.toString();
    }

    public static ScannerModel fromScan(Scan scan) throws Exception {
        Authorizations authorizations;
        Filter filter;
        int maxVersions;
        int batch;
        ScannerModel model = new ScannerModel();
        model.setStartRow(scan.getStartRow());
        model.setEndRow(scan.getStopRow());
        Map families = scan.getFamilyMap();
        if (families != null) {
            for (Map.Entry entry : families.entrySet()) {
                if (entry.getValue() != null) {
                    for (byte[] qualifier : (NavigableSet)entry.getValue()) {
                        model.addColumn(Bytes.add((byte[])((byte[])entry.getKey()), (byte[])COLUMN_DIVIDER, (byte[])qualifier));
                    }
                    continue;
                }
                model.addColumn((byte[])entry.getKey());
            }
        }
        model.setStartTime(scan.getTimeRange().getMin());
        model.setEndTime(scan.getTimeRange().getMax());
        int caching = scan.getCaching();
        if (caching > 0) {
            model.setCaching(caching);
        }
        if ((batch = scan.getBatch()) > 0) {
            model.setBatch(batch);
        }
        if ((maxVersions = scan.getMaxVersions()) > 0) {
            model.setMaxVersions(maxVersions);
        }
        if ((filter = scan.getFilter()) != null) {
            model.setFilter(ScannerModel.stringifyFilter(filter));
        }
        if ((authorizations = scan.getAuthorizations()) != null) {
            List labels = authorizations.getLabels();
            for (String label : labels) {
                model.addLabel(label);
            }
        }
        return model;
    }

    public ScannerModel() {
    }

    public ScannerModel(byte[] startRow, byte[] endRow, List<byte[]> columns, int batch, int caching, long endTime, int maxVersions, String filter) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.columns = columns;
        this.batch = batch;
        this.caching = caching;
        this.endTime = endTime;
        this.maxVersions = maxVersions;
        this.filter = filter;
    }

    public ScannerModel(byte[] startRow, byte[] endRow, List<byte[]> columns, int batch, int caching, long startTime, long endTime, String filter) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.columns = columns;
        this.batch = batch;
        this.caching = caching;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
    }

    public void addColumn(byte[] column) {
        this.columns.add(column);
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public boolean hasStartRow() {
        return !Bytes.equals((byte[])this.startRow, (byte[])HConstants.EMPTY_START_ROW);
    }

    @XmlAttribute
    public byte[] getStartRow() {
        return this.startRow;
    }

    public boolean hasEndRow() {
        return !Bytes.equals((byte[])this.endRow, (byte[])HConstants.EMPTY_END_ROW);
    }

    @XmlAttribute
    public byte[] getEndRow() {
        return this.endRow;
    }

    @XmlElement(name="column")
    public List<byte[]> getColumns() {
        return this.columns;
    }

    @XmlElement(name="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @XmlAttribute
    public int getBatch() {
        return this.batch;
    }

    @XmlAttribute
    public int getCaching() {
        return this.caching;
    }

    @XmlAttribute
    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @XmlAttribute
    public long getStartTime() {
        return this.startTime;
    }

    @XmlAttribute
    public long getEndTime() {
        return this.endTime;
    }

    @XmlAttribute
    public int getMaxVersions() {
        return this.maxVersions;
    }

    @XmlElement
    public String getFilter() {
        return this.filter;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(byte[] endRow) {
        this.endRow = endRow;
    }

    public void setColumns(List<byte[]> columns) {
        this.columns = columns;
    }

    public void setBatch(int batch) {
        this.batch = batch;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public void setCacheBlocks(boolean value) {
        this.cacheBlocks = value;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public byte[] createProtobufOutput() {
        ScannerMessage.Scanner.Builder builder = ScannerMessage.Scanner.newBuilder();
        if (!Bytes.equals((byte[])this.startRow, (byte[])HConstants.EMPTY_START_ROW)) {
            builder.setStartRow(ByteStringer.wrap((byte[])this.startRow));
        }
        if (!Bytes.equals((byte[])this.endRow, (byte[])HConstants.EMPTY_START_ROW)) {
            builder.setEndRow(ByteStringer.wrap((byte[])this.endRow));
        }
        for (byte[] column : this.columns) {
            builder.addColumns(ByteStringer.wrap((byte[])column));
        }
        if (this.startTime != 0L) {
            builder.setStartTime(this.startTime);
        }
        if (this.endTime != 0L) {
            builder.setEndTime(this.endTime);
        }
        builder.setBatch(this.getBatch());
        if (this.caching > 0) {
            builder.setCaching(this.caching);
        }
        builder.setMaxVersions(this.maxVersions);
        if (this.filter != null) {
            builder.setFilter(this.filter);
        }
        if (this.labels != null && this.labels.size() > 0) {
            for (String label : this.labels) {
                builder.addLabels(label);
            }
        }
        builder.setCacheBlocks(this.cacheBlocks);
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        ScannerMessage.Scanner.Builder builder = ScannerMessage.Scanner.newBuilder();
        builder.mergeFrom(message);
        if (builder.hasStartRow()) {
            this.startRow = builder.getStartRow().toByteArray();
        }
        if (builder.hasEndRow()) {
            this.endRow = builder.getEndRow().toByteArray();
        }
        for (ByteString column : builder.getColumnsList()) {
            this.addColumn(column.toByteArray());
        }
        if (builder.hasBatch()) {
            this.batch = builder.getBatch();
        }
        if (builder.hasCaching()) {
            this.caching = builder.getCaching();
        }
        if (builder.hasStartTime()) {
            this.startTime = builder.getStartTime();
        }
        if (builder.hasEndTime()) {
            this.endTime = builder.getEndTime();
        }
        if (builder.hasMaxVersions()) {
            this.maxVersions = builder.getMaxVersions();
        }
        if (builder.hasFilter()) {
            this.filter = builder.getFilter();
        }
        if (builder.getLabelsList() != null) {
            List<String> labels = builder.getLabelsList();
            for (String label : labels) {
                this.addLabel(label);
            }
        }
        if (builder.hasCacheBlocks()) {
            this.cacheBlocks = builder.getCacheBlocks();
        }
        return this;
    }

    @XmlRootElement
    static class FilterModel {
        @XmlAttribute
        public String type;
        @XmlAttribute
        public String op;
        @XmlElement
        ByteArrayComparableModel comparator;
        @XmlAttribute
        public String value;
        @XmlElement
        public List<FilterModel> filters;
        @XmlAttribute
        public Integer limit;
        @XmlAttribute
        public Integer offset;
        @XmlAttribute
        public String family;
        @XmlAttribute
        public String qualifier;
        @XmlAttribute
        public Boolean ifMissing;
        @XmlAttribute
        public Boolean latestVersion;
        @XmlAttribute
        public String minColumn;
        @XmlAttribute
        public Boolean minColumnInclusive;
        @XmlAttribute
        public String maxColumn;
        @XmlAttribute
        public Boolean maxColumnInclusive;
        @XmlAttribute
        public Boolean dropDependentColumn;
        @XmlAttribute
        public Float chance;
        @XmlElement
        public List<String> prefixes;
        @XmlElement
        private List<MultiRowRangeFilter.RowRange> ranges;
        @XmlElement
        public List<Long> timestamps;

        public FilterModel() {
        }

        public FilterModel(Filter filter) {
            String typeName = filter.getClass().getSimpleName();
            FilterType type = FilterType.valueOf(typeName);
            this.type = typeName;
            switch (type) {
                case ColumnCountGetFilter: {
                    this.limit = ((ColumnCountGetFilter)filter).getLimit();
                    break;
                }
                case ColumnPaginationFilter: {
                    this.limit = ((ColumnPaginationFilter)filter).getLimit();
                    this.offset = ((ColumnPaginationFilter)filter).getOffset();
                    break;
                }
                case ColumnPrefixFilter: {
                    this.value = Base64.encodeBytes((byte[])((ColumnPrefixFilter)filter).getPrefix());
                    break;
                }
                case ColumnRangeFilter: {
                    this.minColumn = Base64.encodeBytes((byte[])((ColumnRangeFilter)filter).getMinColumn());
                    this.minColumnInclusive = ((ColumnRangeFilter)filter).getMinColumnInclusive();
                    this.maxColumn = Base64.encodeBytes((byte[])((ColumnRangeFilter)filter).getMaxColumn());
                    this.maxColumnInclusive = ((ColumnRangeFilter)filter).getMaxColumnInclusive();
                    break;
                }
                case DependentColumnFilter: {
                    DependentColumnFilter dcf = (DependentColumnFilter)filter;
                    this.family = Base64.encodeBytes((byte[])dcf.getFamily());
                    byte[] qualifier = dcf.getQualifier();
                    if (qualifier != null) {
                        this.qualifier = Base64.encodeBytes((byte[])qualifier);
                    }
                    this.op = dcf.getOperator().toString();
                    this.comparator = new ByteArrayComparableModel(dcf.getComparator());
                    this.dropDependentColumn = dcf.dropDependentColumn();
                    break;
                }
                case FilterList: {
                    this.op = ((FilterList)filter).getOperator().toString();
                    this.filters = new ArrayList<FilterModel>();
                    for (Filter child : ((FilterList)filter).getFilters()) {
                        this.filters.add(new FilterModel(child));
                    }
                    break;
                }
                case FirstKeyOnlyFilter: 
                case KeyOnlyFilter: {
                    break;
                }
                case InclusiveStopFilter: {
                    this.value = Base64.encodeBytes((byte[])((InclusiveStopFilter)filter).getStopRowKey());
                    break;
                }
                case MultipleColumnPrefixFilter: {
                    this.prefixes = new ArrayList<String>();
                    for (byte[] prefix : ((MultipleColumnPrefixFilter)filter).getPrefix()) {
                        this.prefixes.add(Base64.encodeBytes((byte[])prefix));
                    }
                    break;
                }
                case MultiRowRangeFilter: {
                    this.ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
                    for (MultiRowRangeFilter.RowRange range : ((MultiRowRangeFilter)filter).getRowRanges()) {
                        this.ranges.add(new MultiRowRangeFilter.RowRange(range.getStartRow(), range.isStartRowInclusive(), range.getStopRow(), range.isStopRowInclusive()));
                    }
                    break;
                }
                case PageFilter: {
                    this.value = Long.toString(((PageFilter)filter).getPageSize());
                    break;
                }
                case PrefixFilter: {
                    this.value = Base64.encodeBytes((byte[])((PrefixFilter)filter).getPrefix());
                    break;
                }
                case FamilyFilter: 
                case QualifierFilter: 
                case RowFilter: 
                case ValueFilter: {
                    this.op = ((CompareFilter)filter).getOperator().toString();
                    this.comparator = new ByteArrayComparableModel(((CompareFilter)filter).getComparator());
                    break;
                }
                case RandomRowFilter: {
                    this.chance = Float.valueOf(((RandomRowFilter)filter).getChance());
                    break;
                }
                case SingleColumnValueExcludeFilter: 
                case SingleColumnValueFilter: {
                    SingleColumnValueFilter scvf = (SingleColumnValueFilter)filter;
                    this.family = Base64.encodeBytes((byte[])scvf.getFamily());
                    byte[] qualifier = scvf.getQualifier();
                    if (qualifier != null) {
                        this.qualifier = Base64.encodeBytes((byte[])qualifier);
                    }
                    this.op = scvf.getOperator().toString();
                    this.comparator = new ByteArrayComparableModel(scvf.getComparator());
                    if (scvf.getFilterIfMissing()) {
                        this.ifMissing = true;
                    }
                    if (!scvf.getLatestVersionOnly()) break;
                    this.latestVersion = true;
                    break;
                }
                case SkipFilter: {
                    this.filters = new ArrayList<FilterModel>();
                    this.filters.add(new FilterModel(((SkipFilter)filter).getFilter()));
                    break;
                }
                case TimestampsFilter: {
                    this.timestamps = ((TimestampsFilter)filter).getTimestamps();
                    break;
                }
                case WhileMatchFilter: {
                    this.filters = new ArrayList<FilterModel>();
                    this.filters.add(new FilterModel(((WhileMatchFilter)filter).getFilter()));
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled filter type " + (Object)((Object)type));
                }
            }
        }

        public Filter build() {
            FirstKeyOnlyFilter filter;
            switch (FilterType.valueOf(this.type)) {
                case ColumnCountGetFilter: {
                    filter = new ColumnCountGetFilter(this.limit.intValue());
                    break;
                }
                case ColumnPaginationFilter: {
                    filter = new ColumnPaginationFilter(this.limit.intValue(), this.offset.intValue());
                    break;
                }
                case ColumnPrefixFilter: {
                    filter = new ColumnPrefixFilter(Base64.decode((String)this.value));
                    break;
                }
                case ColumnRangeFilter: {
                    filter = new ColumnRangeFilter(Base64.decode((String)this.minColumn), this.minColumnInclusive.booleanValue(), Base64.decode((String)this.maxColumn), this.maxColumnInclusive.booleanValue());
                    break;
                }
                case DependentColumnFilter: {
                    filter = new DependentColumnFilter(Base64.decode((String)this.family), this.qualifier != null ? Base64.decode((String)this.qualifier) : null, this.dropDependentColumn.booleanValue(), CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    break;
                }
                case FamilyFilter: {
                    filter = new FamilyFilter(CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    break;
                }
                case FilterList: {
                    ArrayList<Filter> list = new ArrayList<Filter>();
                    for (FilterModel model : this.filters) {
                        list.add(model.build());
                    }
                    filter = new FilterList(FilterList.Operator.valueOf((String)this.op), list);
                    break;
                }
                case FirstKeyOnlyFilter: {
                    filter = new FirstKeyOnlyFilter();
                    break;
                }
                case InclusiveStopFilter: {
                    filter = new InclusiveStopFilter(Base64.decode((String)this.value));
                    break;
                }
                case KeyOnlyFilter: {
                    filter = new KeyOnlyFilter();
                    break;
                }
                case MultipleColumnPrefixFilter: {
                    byte[][] values = new byte[this.prefixes.size()][];
                    for (int i = 0; i < this.prefixes.size(); ++i) {
                        values[i] = Base64.decode((String)this.prefixes.get(i));
                    }
                    filter = new MultipleColumnPrefixFilter((byte[][])values);
                    break;
                }
                case MultiRowRangeFilter: {
                    try {
                        filter = new MultiRowRangeFilter(this.ranges);
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case PageFilter: {
                    filter = new PageFilter(Long.valueOf(this.value).longValue());
                    break;
                }
                case PrefixFilter: {
                    filter = new PrefixFilter(Base64.decode((String)this.value));
                    break;
                }
                case QualifierFilter: {
                    filter = new QualifierFilter(CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    break;
                }
                case RandomRowFilter: {
                    filter = new RandomRowFilter(this.chance.floatValue());
                    break;
                }
                case RowFilter: {
                    filter = new RowFilter(CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    break;
                }
                case SingleColumnValueFilter: {
                    filter = new SingleColumnValueFilter(Base64.decode((String)this.family), this.qualifier != null ? Base64.decode((String)this.qualifier) : null, CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    if (this.ifMissing != null) {
                        ((SingleColumnValueFilter)filter).setFilterIfMissing(this.ifMissing.booleanValue());
                    }
                    if (this.latestVersion == null) break;
                    ((SingleColumnValueFilter)filter).setLatestVersionOnly(this.latestVersion.booleanValue());
                    break;
                }
                case SingleColumnValueExcludeFilter: {
                    filter = new SingleColumnValueExcludeFilter(Base64.decode((String)this.family), this.qualifier != null ? Base64.decode((String)this.qualifier) : null, CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    if (this.ifMissing != null) {
                        ((SingleColumnValueExcludeFilter)filter).setFilterIfMissing(this.ifMissing.booleanValue());
                    }
                    if (this.latestVersion == null) break;
                    ((SingleColumnValueExcludeFilter)filter).setLatestVersionOnly(this.latestVersion.booleanValue());
                    break;
                }
                case SkipFilter: {
                    filter = new SkipFilter(this.filters.get(0).build());
                    break;
                }
                case TimestampsFilter: {
                    filter = new TimestampsFilter(this.timestamps);
                    break;
                }
                case ValueFilter: {
                    filter = new ValueFilter(CompareFilter.CompareOp.valueOf((String)this.op), this.comparator.build());
                    break;
                }
                case WhileMatchFilter: {
                    filter = new WhileMatchFilter(this.filters.get(0).build());
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled filter type: " + this.type);
                }
            }
            return filter;
        }

        static enum FilterType {
            ColumnCountGetFilter,
            ColumnPaginationFilter,
            ColumnPrefixFilter,
            ColumnRangeFilter,
            DependentColumnFilter,
            FamilyFilter,
            FilterList,
            FirstKeyOnlyFilter,
            InclusiveStopFilter,
            KeyOnlyFilter,
            MultipleColumnPrefixFilter,
            MultiRowRangeFilter,
            PageFilter,
            PrefixFilter,
            QualifierFilter,
            RandomRowFilter,
            RowFilter,
            SingleColumnValueExcludeFilter,
            SingleColumnValueFilter,
            SkipFilter,
            TimestampsFilter,
            ValueFilter,
            WhileMatchFilter;

        }

        @XmlRootElement
        static class ByteArrayComparableModel {
            @XmlAttribute
            public String type;
            @XmlAttribute
            public String value;
            @XmlAttribute
            public String op;

            public ByteArrayComparableModel() {
            }

            public ByteArrayComparableModel(ByteArrayComparable comparator) {
                String typeName = comparator.getClass().getSimpleName();
                ComparatorType type = ComparatorType.valueOf(typeName);
                this.type = typeName;
                switch (type) {
                    case BinaryComparator: 
                    case BinaryPrefixComparator: {
                        this.value = Base64.encodeBytes((byte[])comparator.getValue());
                        break;
                    }
                    case BitComparator: {
                        this.value = Base64.encodeBytes((byte[])comparator.getValue());
                        this.op = ((BitComparator)comparator).getOperator().toString();
                        break;
                    }
                    case NullComparator: {
                        break;
                    }
                    case RegexStringComparator: 
                    case SubstringComparator: {
                        this.value = Bytes.toString((byte[])comparator.getValue());
                        break;
                    }
                    default: {
                        throw new RuntimeException("unhandled filter type: " + (Object)((Object)type));
                    }
                }
            }

            public ByteArrayComparable build() {
                NullComparator comparator;
                switch (ComparatorType.valueOf(this.type)) {
                    case BinaryComparator: {
                        comparator = new BinaryComparator(Base64.decode((String)this.value));
                        break;
                    }
                    case BinaryPrefixComparator: {
                        comparator = new BinaryPrefixComparator(Base64.decode((String)this.value));
                        break;
                    }
                    case BitComparator: {
                        comparator = new BitComparator(Base64.decode((String)this.value), BitComparator.BitwiseOp.valueOf((String)this.op));
                        break;
                    }
                    case NullComparator: {
                        comparator = new NullComparator();
                        break;
                    }
                    case RegexStringComparator: {
                        comparator = new RegexStringComparator(this.value);
                        break;
                    }
                    case SubstringComparator: {
                        comparator = new SubstringComparator(this.value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unhandled comparator type: " + this.type);
                    }
                }
                return comparator;
            }

            static enum ComparatorType {
                BinaryComparator,
                BinaryPrefixComparator,
                BitComparator,
                NullComparator,
                RegexStringComparator,
                SubstringComparator;

            }
        }
    }
}

