/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.MetricsREST;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.ConnectionCache;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
public class RESTServlet
implements Constants {
    private static Logger LOG = Logger.getLogger(RESTServlet.class);
    private static RESTServlet INSTANCE;
    private final Configuration conf;
    private final MetricsREST metrics = new MetricsREST();
    private final ConnectionCache connectionCache;
    private final UserGroupInformation realUser;
    static final String CLEANUP_INTERVAL = "hbase.rest.connection.cleanup-interval";
    static final String MAX_IDLETIME = "hbase.rest.connection.max-idletime";
    static final String HBASE_REST_SUPPORT_PROXYUSER = "hbase.rest.support.proxyuser";

    UserGroupInformation getRealUser() {
        return this.realUser;
    }

    public static synchronized RESTServlet getInstance() {
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public static synchronized RESTServlet getInstance(Configuration conf, UserProvider userProvider) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new RESTServlet(conf, userProvider);
        }
        return INSTANCE;
    }

    public static synchronized void stop() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
            INSTANCE = null;
        }
    }

    RESTServlet(Configuration conf, UserProvider userProvider) throws IOException {
        this.realUser = userProvider.getCurrent().getUGI();
        this.conf = conf;
        this.registerCustomFilter(conf);
        int cleanInterval = conf.getInt(CLEANUP_INTERVAL, 10000);
        int maxIdleTime = conf.getInt(MAX_IDLETIME, 600000);
        this.connectionCache = new ConnectionCache(conf, userProvider, cleanInterval, maxIdleTime);
        if (this.supportsProxyuser()) {
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        }
    }

    Admin getAdmin() throws IOException {
        return this.connectionCache.getAdmin();
    }

    Table getTable(String tableName) throws IOException {
        return this.connectionCache.getTable(tableName);
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    MetricsREST getMetrics() {
        return this.metrics;
    }

    boolean isReadOnly() {
        return this.getConfiguration().getBoolean("hbase.rest.readonly", false);
    }

    void setEffectiveUser(String effectiveUser) {
        this.connectionCache.setEffectiveUser(effectiveUser);
    }

    void shutdown() {
        if (this.connectionCache != null) {
            this.connectionCache.shutdown();
        }
    }

    boolean supportsProxyuser() {
        return this.conf.getBoolean(HBASE_REST_SUPPORT_PROXYUSER, false);
    }

    private void registerCustomFilter(Configuration conf) {
        String[] filterList = conf.getStrings("hbase.rest.custom.filters");
        if (filterList != null) {
            for (String filterClass : filterList) {
                String[] filterPart = filterClass.split(":");
                if (filterPart.length != 2) {
                    LOG.warn((Object)("Invalid filter specification " + filterClass + " - skipping"));
                    continue;
                }
                ParseFilter.registerFilter((String)filterPart[0], (String)filterPart[1]);
            }
        }
    }
}

