/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Header;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannerResource {
    private static final TableName TABLE = TableName.valueOf((String)"TestScannerResource");
    private static final String NONEXISTENT_TABLE = "ThisTableDoesNotExist";
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static int expectedRows1;
    private static int expectedRows2;
    private static Configuration conf;

    static int insertData(Configuration conf, TableName tableName, String column, double prob) throws IOException {
        Random rng = new Random();
        byte[] k = new byte[3];
        byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.toBytes((String)column));
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int b1 = 97; b1 < 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 < 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 < 122; b3 = (int)((byte)(b3 + 1))) {
                    if (!(rng.nextDouble() < prob)) continue;
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.setDurability(Durability.SKIP_WAL);
                    put.add(famAndQf[0], famAndQf[1], k);
                    puts.add(put);
                }
            }
        }
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table table = conn.getTable(tableName);){
            table.put(puts);
        }
        return puts.size();
    }

    static int countCellSet(CellSetModel model) {
        int count = 0;
        for (RowModel row : model.getRows()) {
            Iterator cells = row.getCells().iterator();
            while (cells.hasNext()) {
                cells.next();
                ++count;
            }
        }
        return count;
    }

    /*
     * Exception decompiling
     */
    private static int fullTableScan(ScannerModel model) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, CellSetModel.class, RowModel.class, ScannerModel.class});
        marshaller = context.createMarshaller();
        unmarshaller = context.createUnmarshaller();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(new HColumnDescriptor(CFA));
        htd.addFamily(new HColumnDescriptor(CFB));
        admin.createTable(htd);
        expectedRows1 = TestScannerResource.insertData(TEST_UTIL.getConfiguration(), TABLE, COLUMN_1, 1.0);
        expectedRows2 = TestScannerResource.insertData(TEST_UTIL.getConfiguration(), TABLE, COLUMN_2, 0.5);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSimpleScannerXML() throws IOException, JAXBException {
        int BATCH_SIZE = 5;
        ScannerModel model = new ScannerModel();
        model.setBatch(5);
        model.addColumn(Bytes.toBytes((String)COLUMN_1));
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        byte[] body = Bytes.toBytes((String)writer.toString());
        conf.set("hbase.rest.readonly", "true");
        Response response = client.put("/" + TABLE + "/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        String scannerURI = response.getLocation();
        Assert.assertNull((Object)scannerURI);
        conf.set("hbase.rest.readonly", "false");
        response = client.put("/" + TABLE + "/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)201L);
        scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertEquals((long)TestScannerResource.countCellSet(cellSet), (long)5L);
        conf.set("hbase.rest.readonly", "true");
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSimpleScannerPB() throws IOException {
        int BATCH_SIZE = 10;
        ScannerModel model = new ScannerModel();
        model.setBatch(10);
        model.addColumn(Bytes.toBytes((String)COLUMN_1));
        conf.set("hbase.rest.readonly", "true");
        Response response = client.put("/" + TABLE + "/scanner", "application/x-protobuf", model.createProtobufOutput());
        Assert.assertEquals((long)response.getCode(), (long)403L);
        String scannerURI = response.getLocation();
        Assert.assertNull((Object)scannerURI);
        conf.set("hbase.rest.readonly", "false");
        response = client.put("/" + TABLE + "/scanner", "application/x-protobuf", model.createProtobufOutput());
        Assert.assertEquals((long)response.getCode(), (long)201L);
        scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "application/x-protobuf");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = new CellSetModel();
        cellSet.getObjectFromMessage(response.getBody());
        Assert.assertEquals((long)TestScannerResource.countCellSet(cellSet), (long)10L);
        conf.set("hbase.rest.readonly", "true");
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSimpleScannerBinary() throws IOException {
        ScannerModel model = new ScannerModel();
        model.setBatch(1);
        model.addColumn(Bytes.toBytes((String)COLUMN_1));
        conf.set("hbase.rest.readonly", "true");
        Response response = client.put("/" + TABLE + "/scanner", "application/x-protobuf", model.createProtobufOutput());
        Assert.assertEquals((long)response.getCode(), (long)403L);
        String scannerURI = response.getLocation();
        Assert.assertNull((Object)scannerURI);
        conf.set("hbase.rest.readonly", "false");
        response = client.put("/" + TABLE + "/scanner", "application/x-protobuf", model.createProtobufOutput());
        Assert.assertEquals((long)response.getCode(), (long)201L);
        scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "application/octet-stream");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/octet-stream", (Object)response.getHeader("content-type"));
        Assert.assertTrue((response.getBody().length > 0 ? 1 : 0) != 0);
        boolean foundRowHeader = false;
        boolean foundColumnHeader = false;
        boolean foundTimestampHeader = false;
        for (Header header : response.getHeaders()) {
            if (header.getName().equals("X-Row")) {
                foundRowHeader = true;
                continue;
            }
            if (header.getName().equals("X-Column")) {
                foundColumnHeader = true;
                continue;
            }
            if (!header.getName().equals("X-Timestamp")) continue;
            foundTimestampHeader = true;
        }
        Assert.assertTrue((boolean)foundRowHeader);
        Assert.assertTrue((boolean)foundColumnHeader);
        Assert.assertTrue((boolean)foundTimestampHeader);
        conf.set("hbase.rest.readonly", "true");
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testFullTableScan() throws IOException {
        ScannerModel model = new ScannerModel();
        model.addColumn(Bytes.toBytes((String)COLUMN_1));
        Assert.assertEquals((long)TestScannerResource.fullTableScan(model), (long)expectedRows1);
        model = new ScannerModel();
        model.addColumn(Bytes.toBytes((String)COLUMN_2));
        Assert.assertEquals((long)TestScannerResource.fullTableScan(model), (long)expectedRows2);
    }

    @Test
    public void testTableDoesNotExist() throws IOException, JAXBException {
        ScannerModel model = new ScannerModel();
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        byte[] body = Bytes.toBytes((String)writer.toString());
        Response response = client.put("/ThisTableDoesNotExist/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)404L);
    }
}

