/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableListModel
extends TestModelBase<TableListModel> {
    private static final String TABLE1 = "table1";
    private static final String TABLE2 = "table2";
    private static final String TABLE3 = "table3";

    public TestTableListModel() throws Exception {
        super(TableListModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><TableList><table name=\"table1\"/><table name=\"table2\"/><table name=\"table3\"/></TableList>";
        this.AS_PB = "CgZ0YWJsZTEKBnRhYmxlMgoGdGFibGUz";
        this.AS_JSON = "{\"table\":[{\"name\":\"table1\"},{\"name\":\"table2\"},{\"name\":\"table3\"}]}";
    }

    @Override
    protected TableListModel buildTestModel() {
        TableListModel model = new TableListModel();
        model.add(new TableModel(TABLE1));
        model.add(new TableModel(TABLE2));
        model.add(new TableModel(TABLE3));
        return model;
    }

    @Override
    protected void checkModel(TableListModel model) {
        Iterator tables = model.getTables().iterator();
        TableModel table = (TableModel)tables.next();
        TestTableListModel.assertEquals((String)table.getName(), (String)TABLE1);
        table = (TableModel)tables.next();
        TestTableListModel.assertEquals((String)table.getName(), (String)TABLE2);
        table = (TableModel)tables.next();
        TestTableListModel.assertEquals((String)table.getName(), (String)TABLE3);
        TestTableListModel.assertFalse((boolean)tables.hasNext());
    }
}

