/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellSetModel
extends TestModelBase<CellSetModel> {
    private static final byte[] ROW1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] COLUMN1 = Bytes.toBytes((String)"testcolumn1");
    private static final byte[] VALUE1 = Bytes.toBytes((String)"testvalue1");
    private static final long TIMESTAMP1 = 1245219839331L;
    private static final byte[] ROW2 = Bytes.toBytes((String)"testrow1");
    private static final byte[] COLUMN2 = Bytes.toBytes((String)"testcolumn2");
    private static final byte[] VALUE2 = Bytes.toBytes((String)"testvalue2");
    private static final long TIMESTAMP2 = 1245239813319L;
    private static final byte[] COLUMN3 = Bytes.toBytes((String)"testcolumn3");
    private static final byte[] VALUE3 = Bytes.toBytes((String)"testvalue3");
    private static final long TIMESTAMP3 = 1245393318192L;

    public TestCellSetModel() throws Exception {
        super(CellSetModel.class);
        this.AS_XML = "<CellSet><Row key=\"dGVzdHJvdzE=\"><Cell timestamp=\"1245219839331\" column=\"dGVzdGNvbHVtbjE=\">dGVzdHZhbHVlMQ==</Cell></Row><Row key=\"dGVzdHJvdzE=\"><Cell timestamp=\"1245239813319\" column=\"dGVzdGNvbHVtbjI=\">dGVzdHZhbHVlMg==</Cell><Cell timestamp=\"1245393318192\" column=\"dGVzdGNvbHVtbjM=\">dGVzdHZhbHVlMw==</Cell></Row></CellSet>";
        this.AS_PB = "CiwKCHRlc3Ryb3cxEiASC3Rlc3Rjb2x1bW4xGOO6i+eeJCIKdGVzdHZhbHVlMQpOCgh0ZXN0cm93MRIgEgt0ZXN0Y29sdW1uMhjHyc7wniQiCnRlc3R2YWx1ZTISIBILdGVzdGNvbHVtbjMYsOLnuZ8kIgp0ZXN0dmFsdWUz";
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><CellSet><Row key=\"dGVzdHJvdzE=\"><Cell column=\"dGVzdGNvbHVtbjE=\" timestamp=\"1245219839331\">dGVzdHZhbHVlMQ==</Cell></Row><Row key=\"dGVzdHJvdzE=\"><Cell column=\"dGVzdGNvbHVtbjI=\" timestamp=\"1245239813319\">dGVzdHZhbHVlMg==</Cell><Cell column=\"dGVzdGNvbHVtbjM=\" timestamp=\"1245393318192\">dGVzdHZhbHVlMw==</Cell></Row></CellSet>";
        this.AS_JSON = "{\"Row\":[{\"key\":\"dGVzdHJvdzE=\",\"Cell\":[{\"column\":\"dGVzdGNvbHVtbjE=\",\"timestamp\":1245219839331,\"$\":\"dGVzdHZhbHVlMQ==\"}]},{\"key\":\"dGVzdHJvdzE=\",\"Cell\":[{\"column\":\"dGVzdGNvbHVtbjI=\",\"timestamp\":1245239813319,\"$\":\"dGVzdHZhbHVlMg==\"},{\"column\":\"dGVzdGNvbHVtbjM=\",\"timestamp\":1245393318192,\"$\":\"dGVzdHZhbHVlMw==\"}]}]}";
    }

    @Override
    protected CellSetModel buildTestModel() {
        CellSetModel model = new CellSetModel();
        RowModel row = new RowModel();
        row.setKey(ROW1);
        row.addCell(new CellModel(COLUMN1, 1245219839331L, VALUE1));
        model.addRow(row);
        row = new RowModel();
        row.setKey(ROW2);
        row.addCell(new CellModel(COLUMN2, 1245239813319L, VALUE2));
        row.addCell(new CellModel(COLUMN3, 1245393318192L, VALUE3));
        model.addRow(row);
        return model;
    }

    @Override
    protected void checkModel(CellSetModel model) {
        Iterator rows = model.getRows().iterator();
        RowModel row = (RowModel)rows.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])ROW1, (byte[])row.getKey()));
        Iterator cells = row.getCells().iterator();
        CellModel cell = (CellModel)cells.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])COLUMN1, (byte[])cell.getColumn()));
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])cell.getValue()));
        TestCellSetModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestCellSetModel.assertEquals((long)cell.getTimestamp(), (long)1245219839331L);
        TestCellSetModel.assertFalse((boolean)cells.hasNext());
        row = (RowModel)rows.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])ROW2, (byte[])row.getKey()));
        cells = row.getCells().iterator();
        cell = (CellModel)cells.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])COLUMN2, (byte[])cell.getColumn()));
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])VALUE2, (byte[])cell.getValue()));
        TestCellSetModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestCellSetModel.assertEquals((long)cell.getTimestamp(), (long)1245239813319L);
        cell = (CellModel)cells.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])COLUMN3, (byte[])cell.getColumn()));
        TestCellSetModel.assertTrue((boolean)Bytes.equals((byte[])VALUE3, (byte[])cell.getValue()));
        TestCellSetModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestCellSetModel.assertEquals((long)cell.getTimestamp(), (long)1245393318192L);
        TestCellSetModel.assertFalse((boolean)cells.hasNext());
    }

    @Override
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    public void testFromXML() throws Exception {
        this.checkModel((CellSetModel)this.fromXML(this.AS_XML));
    }

    @Override
    public void testFromPB() throws Exception {
        this.checkModel((CellSetModel)this.fromPB(this.AS_PB));
    }
}

