/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.RemoteHTable;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestRemoteHTableRetries {
    private static final int SLEEP_TIME = 50;
    private static final int RETRIES = 3;
    private static final long MAX_TIME = 100L;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW_1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] COLUMN_1 = Bytes.toBytes((String)"a");
    private static final byte[] QUALIFIER_1 = Bytes.toBytes((String)"1");
    private static final byte[] VALUE_1 = Bytes.toBytes((String)"testvalue1");
    private Client client;
    private RemoteHTable remoteTable;

    @Before
    public void setup() throws Exception {
        this.client = (Client)Mockito.mock(Client.class);
        Response response = new Response(509);
        Mockito.when((Object)this.client.get(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)response);
        Mockito.when((Object)this.client.delete(Matchers.anyString())).thenReturn((Object)response);
        Mockito.when((Object)this.client.put(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class))).thenReturn((Object)response);
        Mockito.when((Object)this.client.post(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class))).thenReturn((Object)response);
        Configuration configuration = TEST_UTIL.getConfiguration();
        configuration.setInt("hbase.rest.client.max.retries", 3);
        configuration.setInt("hbase.rest.client.sleep", 50);
        this.remoteTable = new RemoteHTable(this.client, TEST_UTIL.getConfiguration(), "MyTable");
    }

    @After
    public void tearDownAfterClass() throws Exception {
        this.remoteTable.close();
    }

    @Test
    public void testDelete() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                Delete delete = new Delete(Bytes.toBytes((String)"delete"));
                TestRemoteHTableRetries.this.remoteTable.delete(delete);
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).delete(Matchers.anyString());
    }

    @Test
    public void testGet() throws Exception {
        this.testTimedOutGetCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteHTableRetries.this.remoteTable.get(new Get(Bytes.toBytes((String)"Get")));
            }
        });
    }

    @Test
    public void testSingleRowPut() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteHTableRetries.this.remoteTable.put(new Put(Bytes.toBytes((String)"Row")));
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).put(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class));
    }

    @Test
    public void testMultiRowPut() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                Put[] puts = new Put[]{new Put(Bytes.toBytes((String)"Row1")), new Put(Bytes.toBytes((String)"Row2"))};
                TestRemoteHTableRetries.this.remoteTable.put(Arrays.asList(puts));
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).put(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class));
    }

    @Test
    public void testGetScanner() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                TestRemoteHTableRetries.this.remoteTable.getScanner(new Scan());
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).post(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class));
    }

    @Test
    public void testCheckAndPut() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                Put put = new Put(ROW_1);
                put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
                TestRemoteHTableRetries.this.remoteTable.checkAndPut(ROW_1, COLUMN_1, QUALIFIER_1, VALUE_1, put);
            }
        });
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).put(Matchers.anyString(), Matchers.anyString(), (byte[])Matchers.any(byte[].class));
    }

    @Test
    public void testCheckAndDelete() throws Exception {
        this.testTimedOutCall(new CallExecutor(){

            @Override
            public void run() throws Exception {
                Put put = new Put(ROW_1);
                put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
                Delete delete = new Delete(ROW_1);
                TestRemoteHTableRetries.this.remoteTable.checkAndDelete(ROW_1, COLUMN_1, QUALIFIER_1, VALUE_1, delete);
            }
        });
    }

    private void testTimedOutGetCall(CallExecutor callExecutor) throws Exception {
        this.testTimedOutCall(callExecutor);
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).get(Matchers.anyString(), Matchers.anyString());
    }

    private void testTimedOutCall(CallExecutor callExecutor) throws Exception {
        long start = System.currentTimeMillis();
        try {
            callExecutor.run();
            Assert.fail((String)"should be timeout exception!");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)Pattern.matches(".*request timed out", e.toString()));
        }
        Assert.assertTrue((System.currentTimeMillis() - start > 100L ? 1 : 0) != 0);
    }

    private static interface CallExecutor {
        public void run() throws Exception;
    }
}

