/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellModel
extends TestModelBase<CellModel> {
    private static final long TIMESTAMP = 1245219839331L;
    private static final byte[] COLUMN = Bytes.toBytes((String)"testcolumn");
    private static final byte[] VALUE = Bytes.toBytes((String)"testvalue");

    public TestCellModel() throws Exception {
        super(CellModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Cell column=\"dGVzdGNvbHVtbg==\" timestamp=\"1245219839331\">dGVzdHZhbHVl</Cell>";
        this.AS_PB = "Egp0ZXN0Y29sdW1uGOO6i+eeJCIJdGVzdHZhbHVl";
        this.AS_JSON = "{\"column\":\"dGVzdGNvbHVtbg==\",\"timestamp\":1245219839331,\"$\":\"dGVzdHZhbHVl\"}";
    }

    @Override
    protected CellModel buildTestModel() {
        CellModel model = new CellModel();
        model.setColumn(COLUMN);
        model.setTimestamp(1245219839331L);
        model.setValue(VALUE);
        return model;
    }

    @Override
    protected void checkModel(CellModel model) {
        TestCellModel.assertTrue((boolean)Bytes.equals((byte[])model.getColumn(), (byte[])COLUMN));
        TestCellModel.assertTrue((boolean)Bytes.equals((byte[])model.getValue(), (byte[])VALUE));
        TestCellModel.assertTrue((boolean)model.hasUserTimestamp());
        TestCellModel.assertEquals((long)model.getTimestamp(), (long)1245219839331L);
    }

    @Override
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    public void testFromXML() throws Exception {
        this.checkModel((CellModel)this.fromXML(this.AS_XML));
    }

    @Override
    public void testFromPB() throws Exception {
        this.checkModel((CellModel)this.fromPB(this.AS_PB));
    }
}

