/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestVersionModel
extends TestModelBase<VersionModel> {
    private static final String REST_VERSION = "0.0.1";
    private static final String OS_VERSION = "Linux 2.6.18-128.1.6.el5.centos.plusxen amd64";
    private static final String JVM_VERSION = "Sun Microsystems Inc. 1.6.0_13-11.3-b02";
    private static final String JETTY_VERSION = "6.1.14";
    private static final String JERSEY_VERSION = "1.1.0-ea";

    public TestVersionModel() throws Exception {
        super(VersionModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Version JVM=\"Sun Microsystems Inc. 1.6.0_13-11.3-b02\" Jersey=\"1.1.0-ea\" OS=\"Linux 2.6.18-128.1.6.el5.centos.plusxen amd64\" REST=\"0.0.1\" Server=\"6.1.14\"/>";
        this.AS_PB = "CgUwLjAuMRInU3VuIE1pY3Jvc3lzdGVtcyBJbmMuIDEuNi4wXzEzLTExLjMtYjAyGi1MaW51eCAyLjYuMTgtMTI4LjEuNi5lbDUuY2VudG9zLnBsdXN4ZW4gYW1kNjQiBjYuMS4xNCoIMS4xLjAtZWE=";
        this.AS_JSON = "{\"JVM\":\"Sun Microsystems Inc. 1.6.0_13-11.3-b02\",\"Jersey\":\"1.1.0-ea\",\"OS\":\"Linux 2.6.18-128.1.6.el5.centos.plusxen amd64\",\"REST\":\"0.0.1\",\"Server\":\"6.1.14\"}";
    }

    @Override
    protected VersionModel buildTestModel() {
        VersionModel model = new VersionModel();
        model.setRESTVersion(REST_VERSION);
        model.setOSVersion(OS_VERSION);
        model.setJVMVersion(JVM_VERSION);
        model.setServerVersion(JETTY_VERSION);
        model.setJerseyVersion(JERSEY_VERSION);
        return model;
    }

    @Override
    protected void checkModel(VersionModel model) {
        TestVersionModel.assertEquals((String)model.getRESTVersion(), (String)REST_VERSION);
        TestVersionModel.assertEquals((String)model.getOSVersion(), (String)OS_VERSION);
        TestVersionModel.assertEquals((String)model.getJVMVersion(), (String)JVM_VERSION);
        TestVersionModel.assertEquals((String)model.getServerVersion(), (String)JETTY_VERSION);
        TestVersionModel.assertEquals((String)model.getJerseyVersion(), (String)JERSEY_VERSION);
    }
}

