/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRowModel
extends TestModelBase<RowModel> {
    private static final byte[] ROW1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] COLUMN1 = Bytes.toBytes((String)"testcolumn1");
    private static final byte[] VALUE1 = Bytes.toBytes((String)"testvalue1");
    private static final long TIMESTAMP1 = 1245219839331L;
    private JAXBContext context;

    public TestRowModel() throws Exception {
        super(RowModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Row key=\"dGVzdHJvdzE=\"><Cell column=\"dGVzdGNvbHVtbjE=\" timestamp=\"1245219839331\">dGVzdHZhbHVlMQ==</Cell></Row>";
        this.AS_JSON = "{\"key\":\"dGVzdHJvdzE=\",\"Cell\":[{\"column\":\"dGVzdGNvbHVtbjE=\",\"timestamp\":1245219839331,\"$\":\"dGVzdHZhbHVlMQ==\"}]}";
    }

    @Override
    protected RowModel buildTestModel() {
        RowModel model = new RowModel();
        model.setKey(ROW1);
        model.addCell(new CellModel(COLUMN1, 1245219839331L, VALUE1));
        return model;
    }

    @Override
    protected void checkModel(RowModel model) {
        TestRowModel.assertTrue((boolean)Bytes.equals((byte[])ROW1, (byte[])model.getKey()));
        Iterator cells = model.getCells().iterator();
        CellModel cell = (CellModel)cells.next();
        TestRowModel.assertTrue((boolean)Bytes.equals((byte[])COLUMN1, (byte[])cell.getColumn()));
        TestRowModel.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])cell.getValue()));
        TestRowModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestRowModel.assertEquals((long)cell.getTimestamp(), (long)1245219839331L);
        TestRowModel.assertFalse((boolean)cells.hasNext());
    }

    @Override
    public void testFromPB() throws Exception {
    }
}

