/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannersWithLabels {
    private static final String TABLE = "TestScannersWithLabels";
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final String TOPSECRET = "topsecret";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static User SUPERUSER;
    private static final HBaseTestingUtility TEST_UTIL;
    private static final HBaseRESTTestingUtility REST_TEST_UTIL;
    private static Client client;
    private static JAXBContext context;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static Configuration conf;

    private static int insertData(String tableName, String column, double prob) throws IOException {
        Random rng = new Random();
        int count = 0;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        byte[] k = new byte[3];
        byte[][] famAndQf = KeyValue.parseColumn((byte[])Bytes.toBytes((String)column));
        for (int i = 0; i < 9; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.setDurability(Durability.SKIP_WAL);
            put.add(famAndQf[0], famAndQf[1], k);
            put.setCellVisibility(new CellVisibility("(secret|confidential)&!topsecret"));
            table.put(put);
            ++count;
        }
        table.flushCommits();
        return count;
    }

    private static int countCellSet(CellSetModel model) {
        int count = 0;
        for (RowModel row : model.getRows()) {
            Iterator cells = row.getCells().iterator();
            while (cells.hasNext()) {
                cells.next();
                ++count;
            }
        }
        return count;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.superuser", SUPERUSER.getShortName());
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestScannersWithLabels.createLabels();
        TestScannersWithLabels.setAuths();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, CellSetModel.class, RowModel.class, ScannerModel.class});
        marshaller = context.createMarshaller();
        unmarshaller = context.createUnmarshaller();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TABLE));
        htd.addFamily(new HColumnDescriptor(CFA));
        htd.addFamily(new HColumnDescriptor(CFB));
        admin.createTable(htd);
        TestScannersWithLabels.insertData(TABLE, COLUMN_1, 1.0);
        TestScannersWithLabels.insertData(TABLE, COLUMN_2, 0.5);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void createLabels() throws IOException, InterruptedException {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestScannersWithLabels.SECRET, TestScannersWithLabels.CONFIDENTIAL, TestScannersWithLabels.PRIVATE, TestScannersWithLabels.PUBLIC, TestScannersWithLabels.TOPSECRET};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    private static void setAuths() throws Exception {
        String[] labels = new String[]{SECRET, CONFIDENTIAL, PRIVATE, PUBLIC, TOPSECRET};
        try {
            VisibilityClient.setAuths((Configuration)conf, (String[])labels, (String)User.getCurrent().getShortName());
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Test
    public void testSimpleScannerXMLWithLabelsThatReceivesNoData() throws IOException, JAXBException {
        int BATCH_SIZE = 5;
        ScannerModel model = new ScannerModel();
        model.setBatch(5);
        model.addColumn(Bytes.toBytes((String)COLUMN_1));
        model.addLabel(PUBLIC);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        byte[] body = Bytes.toBytes((String)writer.toString());
        conf.set("hbase.rest.readonly", "false");
        Response response = client.put("/TestScannersWithLabels/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)201L);
        String scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)204L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testSimpleScannerXMLWithLabelsThatReceivesData() throws IOException, JAXBException {
        ScannerModel model = new ScannerModel();
        model.setBatch(5);
        model.addColumn(Bytes.toBytes((String)COLUMN_1));
        model.addLabel(SECRET);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        byte[] body = Bytes.toBytes((String)writer.toString());
        conf.set("hbase.rest.readonly", "false");
        Response response = client.put("/TestScannersWithLabels/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)201L);
        String scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertEquals((long)TestScannersWithLabels.countCellSet(cellSet), (long)5L);
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        REST_TEST_UTIL = new HBaseRESTTestingUtility();
    }
}

