/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.provider.producer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;

@Provider
@Produces(value={"application/x-protobuf", "application/protobuf"})
@InterfaceAudience.Private
public class ProtobufMessageBodyProducer
implements MessageBodyWriter<ProtobufMessageHandler> {
    private ThreadLocal<byte[]> buffer = new ThreadLocal();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ProtobufMessageHandler.class.isAssignableFrom(type);
    }

    public long getSize(ProtobufMessageHandler m, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(m.createProtobufOutput());
        }
        catch (IOException e) {
            return -1L;
        }
        byte[] bytes = baos.toByteArray();
        this.buffer.set(bytes);
        return bytes.length;
    }

    public void writeTo(ProtobufMessageHandler m, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        byte[] bytes = this.buffer.get();
        entityStream.write(bytes);
        this.buffer.remove();
    }
}

