/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ResourceBase
implements Constants {
    RESTServlet servlet = RESTServlet.getInstance();
    Class<?> accessDeniedClazz;
    Class<?> accessControlExceptionClazz;

    public ResourceBase() throws IOException {
        try {
            this.accessDeniedClazz = Class.forName("org.apache.hadoop.hbase.security.AccessDeniedException");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            this.accessControlExceptionClazz = Class.forName("org.apache.hadoop.security.AccessControlException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected Response processException(Throwable exp) {
        if (this.accessDeniedClazz != null) {
            for (Throwable curr = exp; curr != null; curr = curr.getCause()) {
                if (!this.accessDeniedClazz.isAssignableFrom(curr.getClass()) && !this.accessControlExceptionClazz.isAssignableFrom(curr.getClass())) continue;
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)("Forbidden\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
            }
        }
        if (exp instanceof TableNotFoundException || exp.getCause() instanceof TableNotFoundException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Not found\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
        }
        if (exp instanceof NoSuchColumnFamilyException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Not found\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
        }
        if (exp instanceof RuntimeException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("Bad request\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
        }
        if (exp instanceof RetriesExhaustedWithDetailsException) {
            RetriesExhaustedWithDetailsException retryException = (RetriesExhaustedWithDetailsException)exp;
            this.processException(retryException.getCause(0));
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)("Unavailable\r\n" + StringUtils.stringifyException((Throwable)exp) + "\r\n")).build());
    }
}

