/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableSchemaModel
extends TestModelBase<TableSchemaModel> {
    public static final String TABLE_NAME = "testTable";
    private static final boolean IS_META = false;
    private static final boolean IS_ROOT = false;
    private static final boolean READONLY = false;
    TestColumnSchemaModel testColumnSchemaModel = new TestColumnSchemaModel();
    private JAXBContext context;

    public TestTableSchemaModel() throws Exception {
        super(TableSchemaModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><TableSchema name=\"testTable\" IS_META=\"false\" IS_ROOT=\"false\" READONLY=\"false\"><ColumnSchema name=\"testcolumn\" BLOCKSIZE=\"16384\" BLOOMFILTER=\"NONE\" BLOCKCACHE=\"true\" COMPRESSION=\"GZ\" VERSIONS=\"1\" TTL=\"86400\" IN_MEMORY=\"false\"/></TableSchema>";
        this.AS_PB = "Cgl0ZXN0VGFibGUSEAoHSVNfTUVUQRIFZmFsc2USEAoHSVNfUk9PVBIFZmFsc2USEQoIUkVBRE9OTFkSBWZhbHNlGpcBCgp0ZXN0Y29sdW1uEhIKCUJMT0NLU0laRRIFMTYzODQSEwoLQkxPT01GSUxURVISBE5PTkUSEgoKQkxPQ0tDQUNIRRIEdHJ1ZRIRCgtDT01QUkVTU0lPThICR1oSDQoIVkVSU0lPTlMSATESDAoDVFRMEgU4NjQwMBISCglJTl9NRU1PUlkSBWZhbHNlGICjBSABKgJHWigA";
        this.AS_JSON = "{\"name\":\"testTable\",\"IS_META\":\"false\",\"IS_ROOT\":\"false\",\"READONLY\":\"false\",\"ColumnSchema\":[{\"name\":\"testcolumn\",\"BLOCKSIZE\":\"16384\",\"BLOOMFILTER\":\"NONE\",\"BLOCKCACHE\":\"true\",\"COMPRESSION\":\"GZ\",\"VERSIONS\":\"1\",\"TTL\":\"86400\",\"IN_MEMORY\":\"false\"}]}";
    }

    @Override
    protected TableSchemaModel buildTestModel() {
        return this.buildTestModel(TABLE_NAME);
    }

    public TableSchemaModel buildTestModel(String name) {
        TableSchemaModel model = new TableSchemaModel();
        model.setName(name);
        model.__setIsMeta(false);
        model.__setIsRoot(false);
        model.__setReadOnly(false);
        model.addColumnFamily(this.testColumnSchemaModel.buildTestModel());
        return model;
    }

    @Override
    protected void checkModel(TableSchemaModel model) {
        this.checkModel(model, TABLE_NAME);
    }

    public void checkModel(TableSchemaModel model, String tableName) {
        TestTableSchemaModel.assertEquals((String)model.getName(), (String)tableName);
        TestTableSchemaModel.assertEquals((boolean)model.__getIsMeta(), (boolean)false);
        TestTableSchemaModel.assertEquals((boolean)model.__getIsRoot(), (boolean)false);
        TestTableSchemaModel.assertEquals((boolean)model.__getReadOnly(), (boolean)false);
        Iterator families = model.getColumns().iterator();
        TestTableSchemaModel.assertTrue((boolean)families.hasNext());
        ColumnSchemaModel family = (ColumnSchemaModel)families.next();
        this.testColumnSchemaModel.checkModel(family);
        TestTableSchemaModel.assertFalse((boolean)families.hasNext());
    }

    @Override
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    public void testFromXML() throws Exception {
        this.checkModel((TableSchemaModel)this.fromXML(this.AS_XML));
    }

    @Override
    public void testFromPB() throws Exception {
        this.checkModel((TableSchemaModel)this.fromPB(this.AS_PB));
    }
}

