/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.ProcedureAbortedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Procedure<TEnvironment>
implements Comparable<Procedure> {
    private String owner = null;
    private Long parentProcId = null;
    private Long procId = null;
    private long startTime;
    private ProcedureProtos.ProcedureState state = ProcedureProtos.ProcedureState.INITIALIZING;
    private Integer timeout = null;
    private int[] stackIndexes = null;
    private int childrenLatch = 0;
    private long lastUpdate;
    private RemoteProcedureException exception = null;
    private byte[] result = null;

    protected abstract Procedure[] execute(TEnvironment var1) throws ProcedureYieldException;

    protected abstract void rollback(TEnvironment var1) throws IOException;

    protected abstract boolean abort(TEnvironment var1);

    protected abstract void serializeStateData(OutputStream var1) throws IOException;

    protected abstract void deserializeStateData(InputStream var1) throws IOException;

    protected boolean acquireLock(TEnvironment env) {
        return true;
    }

    protected void releaseLock(TEnvironment env) {
    }

    protected void beforeReplay(TEnvironment env) {
    }

    protected void completionCleanup(TEnvironment env) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringClassDetails(sb);
        if (this.procId != null) {
            sb.append(" id=");
            sb.append(this.getProcId());
        }
        if (this.hasParent()) {
            sb.append(" parent=");
            sb.append(this.getParentProcId());
        }
        if (this.hasOwner()) {
            sb.append(" owner=");
            sb.append(this.getOwner());
        }
        sb.append(" state=");
        sb.append(this.getState());
        return sb.toString();
    }

    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getClass().getName());
    }

    public byte[] getResult() {
        return this.result;
    }

    protected void setResult(byte[] result) {
        this.result = result;
    }

    public long getProcId() {
        return this.procId;
    }

    public boolean hasParent() {
        return this.parentProcId != null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public long getParentProcId() {
        return this.parentProcId;
    }

    public synchronized boolean isFailed() {
        return this.exception != null || this.state == ProcedureProtos.ProcedureState.ROLLEDBACK;
    }

    public synchronized boolean isSuccess() {
        return this.state == ProcedureProtos.ProcedureState.FINISHED && this.exception == null;
    }

    public synchronized boolean isFinished() {
        switch (this.state) {
            case ROLLEDBACK: {
                return true;
            }
            case FINISHED: {
                return this.exception == null;
            }
        }
        return false;
    }

    public synchronized boolean isWaiting() {
        switch (this.state) {
            case WAITING: 
            case WAITING_TIMEOUT: {
                return true;
            }
        }
        return false;
    }

    public synchronized RemoteProcedureException getException() {
        return this.exception;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public synchronized long getLastUpdate() {
        return this.lastUpdate;
    }

    public synchronized long elapsedTime() {
        return this.lastUpdate - this.startTime;
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getTimeRemaining() {
        return Math.max(0L, (long)this.timeout.intValue() - (EnvironmentEdgeManager.currentTime() - this.startTime));
    }

    protected void setOwner(String owner) {
        this.owner = StringUtils.isEmpty(owner) ? null : owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected synchronized void setState(ProcedureProtos.ProcedureState state) {
        this.state = state;
        this.updateTimestamp();
    }

    @InterfaceAudience.Private
    protected synchronized ProcedureProtos.ProcedureState getState() {
        return this.state;
    }

    protected void setFailure(String source, Throwable cause) {
        this.setFailure(new RemoteProcedureException(source, cause));
    }

    protected synchronized void setFailure(RemoteProcedureException exception) {
        this.exception = exception;
        if (!this.isFinished()) {
            this.setState(ProcedureProtos.ProcedureState.FINISHED);
        }
    }

    protected void setAbortFailure(String source, String msg) {
        this.setFailure(source, new ProcedureAbortedException(msg));
    }

    @InterfaceAudience.Private
    protected synchronized boolean setTimeoutFailure() {
        if (this.state == ProcedureProtos.ProcedureState.WAITING_TIMEOUT) {
            long timeDiff = EnvironmentEdgeManager.currentTime() - this.lastUpdate;
            this.setFailure("ProcedureExecutor", new TimeoutException("Operation timed out after " + StringUtils.humanTimeDiff(timeDiff)));
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setProcId(long procId) {
        this.procId = procId;
        this.startTime = EnvironmentEdgeManager.currentTime();
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
    }

    @InterfaceAudience.Private
    protected void setParentProcId(long parentProcId) {
        this.parentProcId = parentProcId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected Procedure[] doExecute(TEnvironment env) throws ProcedureYieldException {
        try {
            this.updateTimestamp();
            Procedure[] procedureArray = this.execute(env);
            return procedureArray;
        }
        finally {
            this.updateTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected void doRollback(TEnvironment env) throws IOException {
        try {
            this.updateTimestamp();
            this.rollback(env);
        }
        finally {
            this.updateTimestamp();
        }
    }

    @InterfaceAudience.Private
    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private synchronized void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    protected synchronized void updateTimestamp() {
        this.lastUpdate = EnvironmentEdgeManager.currentTime();
    }

    @InterfaceAudience.Private
    protected synchronized void setChildrenLatch(int numChildren) {
        this.childrenLatch = numChildren;
    }

    @InterfaceAudience.Private
    protected synchronized void incChildrenLatch() {
        ++this.childrenLatch;
    }

    @InterfaceAudience.Private
    protected synchronized boolean childrenCountDown() {
        assert (this.childrenLatch > 0);
        return --this.childrenLatch == 0;
    }

    @InterfaceAudience.Private
    protected synchronized void addStackIndex(int index) {
        if (this.stackIndexes == null) {
            this.stackIndexes = new int[]{index};
        } else {
            int count = this.stackIndexes.length;
            this.stackIndexes = Arrays.copyOf(this.stackIndexes, count + 1);
            this.stackIndexes[count] = index;
        }
    }

    @InterfaceAudience.Private
    protected synchronized boolean removeStackIndex() {
        if (this.stackIndexes.length > 1) {
            this.stackIndexes = Arrays.copyOf(this.stackIndexes, this.stackIndexes.length - 1);
            return false;
        }
        this.stackIndexes = null;
        return true;
    }

    @InterfaceAudience.Private
    protected synchronized void setStackIndexes(List<Integer> stackIndexes) {
        this.stackIndexes = new int[stackIndexes.size()];
        for (int i = 0; i < this.stackIndexes.length; ++i) {
            this.stackIndexes[i] = stackIndexes.get(i);
        }
    }

    @InterfaceAudience.Private
    protected synchronized boolean wasExecuted() {
        return this.stackIndexes != null;
    }

    @InterfaceAudience.Private
    protected synchronized int[] getStackIndexes() {
        return this.stackIndexes;
    }

    @Override
    public int compareTo(Procedure other) {
        long diff = this.getProcId() - other.getProcId();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    @InterfaceAudience.Private
    protected static Long getRootProcedureId(Map<Long, Procedure> procedures, Procedure proc) {
        while (proc.hasParent()) {
            if ((proc = procedures.get(proc.getParentProcId())) != null) continue;
            return null;
        }
        return proc.getProcId();
    }

    protected static Procedure newInstance(String className) throws IOException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new Exception("the " + clazz + " class is not public");
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            assert (ctor != null) : "no constructor found";
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new Exception("the " + clazz + " constructor is not public");
            }
            return (Procedure)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("The procedure class " + className + " must be accessible and have an empty constructor", e);
        }
    }

    protected static void validateClass(Procedure proc) throws IOException {
        try {
            Class<?> clazz = proc.getClass();
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new Exception("the " + clazz + " class is not public");
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            assert (ctor != null);
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new Exception("the " + clazz + " constructor is not public");
            }
        }
        catch (Exception e) {
            throw new IOException("The procedure class " + proc.getClass().getName() + " must be accessible and have an empty constructor", e);
        }
    }

    @InterfaceAudience.Private
    public static ProcedureProtos.Procedure convert(Procedure proc) throws IOException {
        byte[] result;
        int[] stackIds;
        Preconditions.checkArgument((proc != null ? 1 : 0) != 0);
        Procedure.validateClass(proc);
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder().setClassName(proc.getClass().getName()).setProcId(proc.getProcId()).setState(proc.getState()).setStartTime(proc.getStartTime()).setLastUpdate(proc.getLastUpdate());
        if (proc.hasParent()) {
            builder.setParentId(proc.getParentProcId());
        }
        if (proc.hasTimeout()) {
            builder.setTimeout(proc.getTimeout());
        }
        if (proc.hasOwner()) {
            builder.setOwner(proc.getOwner());
        }
        if ((stackIds = proc.getStackIndexes()) != null) {
            for (int i = 0; i < stackIds.length; ++i) {
                builder.addStackId(stackIds[i]);
            }
        }
        if (proc.hasException()) {
            RemoteProcedureException exception = proc.getException();
            builder.setException(RemoteProcedureException.toProto(exception.getSource(), exception.getCause()));
        }
        if ((result = proc.getResult()) != null) {
            builder.setResult(ByteStringer.wrap((byte[])result));
        }
        ByteString.Output stateStream = ByteString.newOutput();
        proc.serializeStateData((OutputStream)stateStream);
        if (stateStream.size() > 0) {
            builder.setStateData(stateStream.toByteString());
        }
        return builder.build();
    }

    @InterfaceAudience.Private
    public static Procedure convert(ProcedureProtos.Procedure proto) throws IOException {
        Procedure proc = Procedure.newInstance(proto.getClassName());
        proc.setProcId(proto.getProcId());
        proc.setState(proto.getState());
        proc.setStartTime(proto.getStartTime());
        proc.setLastUpdate(proto.getLastUpdate());
        if (proto.hasParentId()) {
            proc.setParentProcId(proto.getParentId());
        }
        if (proto.hasOwner()) {
            proc.setOwner(proto.getOwner());
        }
        if (proto.hasTimeout()) {
            proc.setTimeout(proto.getTimeout());
        }
        if (proto.getStackIdCount() > 0) {
            proc.setStackIndexes(proto.getStackIdList());
        }
        if (proto.hasException()) {
            assert (proc.getState() == ProcedureProtos.ProcedureState.FINISHED || proc.getState() == ProcedureProtos.ProcedureState.ROLLEDBACK) : "The procedure must be failed (waiting to rollback) or rolledback";
            proc.setFailure(RemoteProcedureException.fromProto(proto.getException()));
        }
        if (proto.hasResult()) {
            proc.setResult(proto.getResult().toByteArray());
        }
        proc.deserializeStateData(proto.getStateData().newInput());
        return proc;
    }
}

