/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALProcedureStore {
    private static final Log LOG = LogFactory.getLog(TestWALProcedureStore.class);
    private static final int PROCEDURE_STORE_SLOTS = 1;
    private static final Procedure NULL_PROC = null;
    private WALProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.fs, this.logDir);
        this.procStore.start(1);
        this.procStore.recoverLease();
    }

    @After
    public void tearDown() throws IOException {
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    private Iterator<Procedure> storeRestart() throws Exception {
        this.procStore.stop(false);
        this.procStore.start(1);
        this.procStore.recoverLease();
        return this.procStore.load();
    }

    @Test
    public void testEmptyLogLoad() throws Exception {
        Iterator<Procedure> loader = this.storeRestart();
        Assert.assertEquals((long)0L, (long)this.countProcedures(loader));
    }

    @Test
    public void testLoad() throws Exception {
        HashSet<Long> procIds = new HashSet<Long>();
        TestSequentialProcedure proc1 = new TestSequentialProcedure();
        procIds.add(proc1.getProcId());
        this.procStore.insert((Procedure)proc1, null);
        TestSequentialProcedure proc2 = new TestSequentialProcedure();
        Procedure[] child2 = new Procedure[]{new TestSequentialProcedure(), new TestSequentialProcedure()};
        procIds.add(proc2.getProcId());
        procIds.add(child2[0].getProcId());
        procIds.add(child2[1].getProcId());
        this.procStore.insert((Procedure)proc2, child2);
        this.verifyProcIdsOnRestart(procIds);
        this.procStore.update((Procedure)proc1);
        this.procStore.update(child2[1]);
        this.procStore.delete(child2[1].getProcId());
        procIds.remove(child2[1].getProcId());
        this.verifyProcIdsOnRestart(procIds);
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)3L, (long)logs.length);
        for (int i = 0; i < logs.length; ++i) {
            this.corruptLog(logs[i], 4L);
        }
        this.verifyProcIdsOnRestart(procIds);
    }

    @Test
    public void testCorruptedTrailer() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.procStore.insert((Procedure)new TestSequentialProcedure(), null);
        }
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)logs.length);
        this.corruptLog(logs[0], 4L);
        int count = this.countProcedures(this.storeRestart());
        Assert.assertEquals((long)100L, (long)count);
    }

    @Test
    public void testCorruptedEntries() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.procStore.insert((Procedure)new TestSequentialProcedure(), null);
        }
        this.procStore.stop(false);
        FileStatus[] logs = this.fs.listStatus(this.logDir);
        Assert.assertEquals((long)1L, (long)logs.length);
        this.corruptLog(logs[0], 1823L);
        int count = this.countProcedures(this.storeRestart());
        Assert.assertTrue((this.procStore.getCorruptedLogs() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.procStore.getCorruptedLogs().size());
        Assert.assertEquals((long)85L, (long)count);
    }

    private void corruptLog(FileStatus logFile, long dropBytes) throws IOException {
        Assert.assertTrue((logFile.getLen() > dropBytes ? 1 : 0) != 0);
        LOG.debug((Object)("corrupt log " + logFile.getPath() + " size=" + logFile.getLen() + " drop=" + dropBytes));
        Path tmpPath = new Path(this.testDir, "corrupted.log");
        FSDataInputStream in = this.fs.open(logFile.getPath());
        FSDataOutputStream out = this.fs.create(tmpPath);
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (long)(logFile.getLen() - dropBytes), (boolean)true);
        this.fs.rename(tmpPath, logFile.getPath());
    }

    private void verifyProcIdsOnRestart(Set<Long> procIds) throws Exception {
        int count = 0;
        Iterator<Procedure> loader = this.storeRestart();
        while (loader.hasNext()) {
            Procedure proc = loader.next();
            LOG.debug((Object)("loading procId=" + proc.getProcId()));
            Assert.assertTrue((String)("procId=" + proc.getProcId() + " unexpected"), (boolean)procIds.contains(proc.getProcId()));
            ++count;
        }
        Assert.assertEquals((long)procIds.size(), (long)count);
    }

    private void assertIsEmpty(Iterator<Procedure> iterator) {
        Assert.assertEquals((long)0L, (long)this.countProcedures(iterator));
    }

    private int countProcedures(Iterator<Procedure> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            Procedure proc = iterator.next();
            LOG.trace((Object)("loading procId=" + proc.getProcId()));
            ++count;
        }
        return count;
    }

    private void assertEmptyLogDir() {
        try {
            FileStatus[] status = this.fs.listStatus(this.logDir);
            Assert.assertTrue((String)"expected empty state-log dir", (status == null || status.length == 0 ? 1 : 0) != 0);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("expected the state-log dir to be present: " + this.logDir));
        }
        catch (IOException e) {
            Assert.fail((String)("got en exception on state-log dir list: " + e.getMessage()));
        }
    }

    public static class TestSequentialProcedure
    extends SequentialProcedure<Void> {
        private static long seqid = 0L;

        public TestSequentialProcedure() {
            this.setProcId(++seqid);
        }

        protected Procedure[] execute(Void env) {
            return null;
        }

        protected void rollback(Void env) {
        }

        protected boolean abort(Void env) {
            return false;
        }

        protected void serializeStateData(OutputStream stream) throws IOException {
            long procId = this.getProcId();
            if (procId % 2L == 0L) {
                stream.write(Bytes.toBytes((long)procId));
            }
        }

        protected void deserializeStateData(InputStream stream) throws IOException {
            long procId = this.getProcId();
            if (procId % 2L == 0L) {
                byte[] bProcId = new byte[8];
                Assert.assertEquals((long)8L, (long)stream.read(bProcId));
                Assert.assertEquals((long)procId, (long)Bytes.toLong((byte[])bProcId));
            } else {
                Assert.assertEquals((long)0L, (long)stream.available());
            }
        }
    }
}

