/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestProcedureReplayOrder {
    private static final Log LOG = LogFactory.getLog(TestProcedureReplayOrder.class);
    private static final Procedure NULL_PROC = null;
    private ProcedureExecutor<Void> procExecutor;
    private TestProcedureEnv procEnv;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.htu.getConfiguration().setInt("hbase.procedure.store.wal.sync.wait.msec", 10);
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procEnv = new TestProcedureEnv();
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.fs, this.logDir);
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)this.procEnv, this.procStore);
        this.procStore.start(24);
        this.procExecutor.start(1);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test(timeout=90000L)
    public void testSingleStepReplyOrder() throws Exception {
        this.procEnv.setAcquireLock(false);
        this.submitProcedures(16, 25, TestSingleStepProcedure.class);
        ProcedureTestingUtility.restart(this.procExecutor, new Runnable(){

            @Override
            public void run() {
                TestProcedureReplayOrder.this.procEnv.setAcquireLock(true);
            }
        });
        ProcedureTestingUtility.waitNoProcedureRunning(this.procExecutor);
        this.procEnv.assertSortedExecList();
    }

    @Ignore
    @Test(timeout=90000L)
    public void testMultiStepReplyOrder() throws Exception {
        this.procEnv.setAcquireLock(false);
        this.submitProcedures(16, 10, TestTwoStepProcedure.class);
        ProcedureTestingUtility.restart(this.procExecutor, new Runnable(){

            @Override
            public void run() {
                TestProcedureReplayOrder.this.procEnv.setAcquireLock(true);
            }
        });
        Assert.fail((String)"TODO: FIXME: NOT IMPLEMENT REPLAY ORDER");
    }

    private void submitProcedures(int nthreads, final int nprocPerThread, final Class<?> procClazz) throws Exception {
        int i;
        Thread[] submitThreads = new Thread[nthreads];
        for (i = 0; i < submitThreads.length; ++i) {
            submitThreads[i] = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < nprocPerThread; ++i) {
                        try {
                            TestProcedureReplayOrder.this.procExecutor.submitProcedure((Procedure)procClazz.newInstance());
                            continue;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            LOG.error((Object)"unable to instantiate the procedure", (Throwable)e);
                            Assert.fail((String)("failure during the proc.newInstance(): " + e.getMessage()));
                        }
                    }
                }
            };
        }
        for (i = 0; i < submitThreads.length; ++i) {
            submitThreads[i].start();
        }
        for (i = 0; i < submitThreads.length; ++i) {
            submitThreads[i].join();
        }
    }

    public static class TestTwoStepProcedure
    extends SequentialProcedure<TestProcedureEnv> {
        protected Procedure[] execute(TestProcedureEnv env) {
            LOG.debug((Object)("execute procedure " + (Object)((Object)this)));
            env.addToExecList((Procedure)this);
            return new Procedure[]{new TestSingleStepProcedure()};
        }

        protected boolean acquireLock(TestProcedureEnv env) {
            return true;
        }

        protected void rollback(TestProcedureEnv env) {
        }

        protected boolean abort(TestProcedureEnv env) {
            return true;
        }
    }

    public static class TestSingleStepProcedure
    extends SequentialProcedure<TestProcedureEnv> {
        protected Procedure[] execute(TestProcedureEnv env) {
            LOG.debug((Object)("execute procedure " + (Object)((Object)this)));
            env.addToExecList((Procedure)this);
            return null;
        }

        protected boolean acquireLock(TestProcedureEnv env) {
            return env.canAcquireLock();
        }

        protected void rollback(TestProcedureEnv env) {
        }

        protected boolean abort(TestProcedureEnv env) {
            return true;
        }
    }

    private static class TestProcedureEnv {
        private ArrayList<Long> execList = new ArrayList();
        private boolean acquireLock = true;

        private TestProcedureEnv() {
        }

        public void setAcquireLock(boolean acquireLock) {
            this.acquireLock = acquireLock;
        }

        public boolean canAcquireLock() {
            return this.acquireLock;
        }

        public void addToExecList(Procedure proc) {
            this.execList.add(proc.getProcId());
        }

        public ArrayList<Long> getExecList() {
            return this.execList;
        }

        public void assertSortedExecList() {
            LOG.debug((Object)("EXEC LIST: " + this.execList));
            for (int i = 1; i < this.execList.size(); ++i) {
                Assert.assertTrue((String)("exec list not sorted: " + this.execList.get(i - 1) + " >= " + this.execList.get(i)), (this.execList.get(i - 1) < this.execList.get(i) ? 1 : 0) != 0);
            }
        }
    }
}

